/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.springframework.core.log.LogAccessor;
import org.springframework.kafka.listener.ListenerUtils;
import org.springframework.kafka.support.TopicPartitionOffset;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.backoff.BackOff;
import org.springframework.util.backoff.BackOffExecution;

class FailedRecordTracker {
    private final ThreadLocal<Map<TopicPartition, FailedRecord>> failures = new ThreadLocal();
    private final BiConsumer<ConsumerRecord<?, ?>, Exception> recoverer;
    private final boolean noRetries;
    private final BackOff backOff;
    private BiFunction<ConsumerRecord<?, ?>, Exception, BackOff> backOffFunction;
    private boolean resetStateOnRecoveryFailure = true;

    FailedRecordTracker(@Nullable BiConsumer<ConsumerRecord<?, ?>, Exception> recoverer, BackOff backOff, LogAccessor logger) {
        Assert.notNull((Object)backOff, (String)"'backOff' cannot be null");
        this.recoverer = recoverer == null ? (rec, thr) -> {
            Map<TopicPartition, FailedRecord> map = this.failures.get();
            FailedRecord failedRecord = null;
            if (map != null) {
                failedRecord = map.get(new TopicPartition(rec.topic(), rec.partition()));
            }
            logger.error((Throwable)thr, (CharSequence)("Backoff " + (failedRecord == null ? "none" : failedRecord.getBackOffExecution()) + " exhausted for " + ListenerUtils.recordToString(rec)));
        } : recoverer;
        this.noRetries = backOff.start().nextBackOff() == -1L;
        this.backOff = backOff;
    }

    public void setBackOffFunction(BiFunction<ConsumerRecord<?, ?>, Exception, BackOff> backOffFunction) {
        this.backOffFunction = backOffFunction;
    }

    public void setResetStateOnRecoveryFailure(boolean resetStateOnRecoveryFailure) {
        this.resetStateOnRecoveryFailure = resetStateOnRecoveryFailure;
    }

    boolean skip(ConsumerRecord<?, ?> record, Exception exception) {
        TopicPartition topicPartition;
        FailedRecord failedRecord;
        if (this.noRetries) {
            this.attemptRecovery(record, exception, null);
            return true;
        }
        Map<TopicPartition, FailedRecord> map = this.failures.get();
        if (map == null) {
            this.failures.set(new HashMap());
            map = this.failures.get();
        }
        if ((failedRecord = map.get(topicPartition = new TopicPartition(record.topic(), record.partition()))) == null || failedRecord.getOffset() != record.offset()) {
            failedRecord = new FailedRecord(record.offset(), this.determineBackOff(record, exception).start());
            map.put(topicPartition, failedRecord);
        } else {
            failedRecord.getDeliveryAttempts().incrementAndGet();
        }
        long nextBackOff = failedRecord.getBackOffExecution().nextBackOff();
        if (nextBackOff != -1L) {
            try {
                Thread.sleep(nextBackOff);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return false;
        }
        this.attemptRecovery(record, exception, topicPartition);
        map.remove(topicPartition);
        if (map.isEmpty()) {
            this.failures.remove();
        }
        return true;
    }

    private BackOff determineBackOff(ConsumerRecord<?, ?> record, Exception exception) {
        if (this.backOffFunction == null) {
            return this.backOff;
        }
        BackOff backOffToUse = this.backOffFunction.apply(record, exception);
        return backOffToUse != null ? backOffToUse : this.backOff;
    }

    private void attemptRecovery(ConsumerRecord<?, ?> record, Exception exception, @Nullable TopicPartition tp) {
        try {
            this.recoverer.accept(record, exception);
        }
        catch (RuntimeException e) {
            if (tp != null && this.resetStateOnRecoveryFailure) {
                this.failures.get().remove(tp);
            }
            throw e;
        }
    }

    void clearThreadState() {
        this.failures.remove();
    }

    BiConsumer<ConsumerRecord<?, ?>, Exception> getRecoverer() {
        return this.recoverer;
    }

    int deliveryAttempt(TopicPartitionOffset topicPartitionOffset) {
        Map<TopicPartition, FailedRecord> map = this.failures.get();
        if (map == null) {
            return 1;
        }
        FailedRecord failedRecord = map.get(topicPartitionOffset.getTopicPartition());
        if (failedRecord == null || failedRecord.getOffset() != topicPartitionOffset.getOffset().longValue()) {
            return 1;
        }
        return failedRecord.getDeliveryAttempts().get() + 1;
    }

    private static final class FailedRecord {
        private final long offset;
        private final BackOffExecution backOffExecution;
        private final AtomicInteger deliveryAttempts = new AtomicInteger(1);

        FailedRecord(long offset, BackOffExecution backOffExecution) {
            this.offset = offset;
            this.backOffExecution = backOffExecution;
        }

        long getOffset() {
            return this.offset;
        }

        BackOffExecution getBackOffExecution() {
            return this.backOffExecution;
        }

        AtomicInteger getDeliveryAttempts() {
            return this.deliveryAttempts;
        }
    }
}

