/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.converter;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.utils.Bytes;
import org.springframework.kafka.support.converter.ConversionException;
import org.springframework.kafka.support.converter.DefaultJackson2JavaTypeMapper;
import org.springframework.kafka.support.converter.Jackson2JavaTypeMapper;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;

public class MappingJacksonParameterizedConverter
extends MappingJackson2MessageConverter {
    private static final JavaType OBJECT = TypeFactory.defaultInstance().constructType(Object.class);
    private Jackson2JavaTypeMapper typeMapper = new DefaultJackson2JavaTypeMapper();

    public MappingJacksonParameterizedConverter() {
    }

    public MappingJacksonParameterizedConverter(MimeType ... supportedMimeTypes) {
        super(supportedMimeTypes);
    }

    public Jackson2JavaTypeMapper getTypeMapper() {
        return this.typeMapper;
    }

    public void setTypeMapper(Jackson2JavaTypeMapper typeMapper) {
        Assert.notNull((Object)typeMapper, (String)"'typeMapper' cannot be null");
        this.typeMapper = typeMapper;
    }

    @Nullable
    protected Object convertFromInternal(Message<?> message, Class<?> targetClass, @Nullable Object conversionHint) {
        JavaType javaType = this.determineJavaType(message, conversionHint);
        Object value = message.getPayload();
        if (value instanceof Bytes) {
            value = ((Bytes)value).get();
        }
        if (value instanceof String) {
            try {
                return this.getObjectMapper().readValue((String)value, javaType);
            }
            catch (IOException e) {
                throw new ConversionException("Failed to convert from JSON", e);
            }
        }
        if (value instanceof byte[]) {
            try {
                return this.getObjectMapper().readValue((byte[])value, javaType);
            }
            catch (IOException e) {
                throw new ConversionException("Failed to convert from JSON", e);
            }
        }
        throw new IllegalStateException("Only String, Bytes, or byte[] supported");
    }

    private JavaType determineJavaType(Message<?> message, @Nullable Object hint) {
        JavaType javaType = null;
        Type type = null;
        if (hint instanceof Type) {
            type = (Type)hint;
            Headers nativeHeaders = (Headers)message.getHeaders().get((Object)"kafka_nativeHeaders", Headers.class);
            if (nativeHeaders != null) {
                JavaType javaType2 = javaType = this.typeMapper.getTypePrecedence().equals((Object)Jackson2JavaTypeMapper.TypePrecedence.INFERRED) ? TypeFactory.defaultInstance().constructType(type) : this.typeMapper.toJavaType(nativeHeaders);
            }
        }
        if (javaType == null) {
            javaType = type != null ? TypeFactory.defaultInstance().constructType(type) : OBJECT;
        }
        return javaType;
    }
}

