/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.function.BiConsumer;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.springframework.core.log.LogAccessor;
import org.springframework.kafka.listener.CommonErrorHandler;
import org.springframework.kafka.listener.ConsumerRecordRecoverer;
import org.springframework.kafka.listener.ErrorHandlerAdapter;
import org.springframework.kafka.listener.ErrorHandlingUtils;
import org.springframework.kafka.listener.KafkaExceptionLogLevelAware;
import org.springframework.kafka.listener.ListenerInvokingBatchErrorHandler;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.kafka.listener.SeekToCurrentBatchErrorHandler;
import org.springframework.lang.Nullable;
import org.springframework.util.backoff.BackOff;
import org.springframework.util.backoff.FixedBackOff;

public class RetryingBatchErrorHandler
extends KafkaExceptionLogLevelAware
implements ListenerInvokingBatchErrorHandler {
    private static final LogAccessor LOGGER = new LogAccessor(LogFactory.getLog(RetryingBatchErrorHandler.class));
    private final BackOff backOff;
    private final BiConsumer<ConsumerRecords<?, ?>, Exception> recoverer;
    private final CommonErrorHandler seeker = new ErrorHandlerAdapter(new SeekToCurrentBatchErrorHandler());
    private boolean ackAfterHandle = true;

    public RetryingBatchErrorHandler() {
        this((BackOff)new FixedBackOff(), null);
    }

    public RetryingBatchErrorHandler(BackOff backOff, @Nullable ConsumerRecordRecoverer recoverer) {
        this.backOff = backOff;
        this.recoverer = (crs, ex) -> {
            if (recoverer == null) {
                LOGGER.error((Throwable)ex, () -> "Records discarded: " + ErrorHandlingUtils.recordsToString(crs));
            } else {
                crs.spliterator().forEachRemaining(rec -> recoverer.accept(rec, ex));
            }
        };
    }

    @Override
    public boolean isAckAfterHandle() {
        return this.ackAfterHandle;
    }

    @Override
    public void setAckAfterHandle(boolean ackAfterHandle) {
        this.ackAfterHandle = ackAfterHandle;
    }

    @Override
    public void handle(Exception thrownException, @Nullable ConsumerRecords<?, ?> records, Consumer<?, ?> consumer, MessageListenerContainer container, Runnable invokeListener) {
        if (records == null || records.count() == 0) {
            LOGGER.error((Throwable)thrownException, (CharSequence)"Called with no records; consumer exception");
            return;
        }
        ErrorHandlingUtils.retryBatch(thrownException, records, consumer, container, invokeListener, this.backOff, this.seeker, this.recoverer, LOGGER, this.getLogLevel());
    }
}

