/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public final class KafkaUtils {
    private static Function<ProducerRecord<?, ?>, String> prFormatter = rec -> rec.toString();
    private static Function<ConsumerRecord<?, ?>, String> crFormatter = rec -> rec.topic() + "-" + rec.partition() + "@" + rec.offset();
    public static final boolean MICROMETER_PRESENT = ClassUtils.isPresent((String)"io.micrometer.core.instrument.MeterRegistry", (ClassLoader)KafkaUtils.class.getClassLoader());
    private static final ThreadLocal<String> GROUP_IDS = new ThreadLocal();

    public static boolean returnTypeMessageOrCollectionOf(Method method) {
        Type returnType = method.getGenericReturnType();
        if (returnType.equals(Message.class)) {
            return true;
        }
        if (returnType instanceof ParameterizedType) {
            ParameterizedType prt = (ParameterizedType)returnType;
            Type rawType = prt.getRawType();
            if (rawType.equals(Message.class)) {
                return true;
            }
            if (rawType.equals(Collection.class)) {
                Type collectionType = prt.getActualTypeArguments()[0];
                if (collectionType.equals(Message.class)) {
                    return true;
                }
                return collectionType instanceof ParameterizedType && ((ParameterizedType)collectionType).getRawType().equals(Message.class);
            }
        }
        return false;
    }

    public static void setConsumerGroupId(String groupId) {
        GROUP_IDS.set(groupId);
    }

    public static String getConsumerGroupId() {
        return GROUP_IDS.get();
    }

    public static void clearConsumerGroupId() {
        GROUP_IDS.remove();
    }

    public static Duration determineSendTimeout(Map<String, Object> producerProps, long buffer, long min) {
        Object dt = producerProps.get("delivery.timeout.ms");
        if (dt instanceof Number) {
            return Duration.ofMillis(Math.max(((Number)dt).longValue() + buffer, min));
        }
        if (dt instanceof String) {
            try {
                return Duration.ofMillis(Math.max(Long.parseLong((String)dt) + buffer, min));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Duration.ofMillis(Math.max(((Integer)ProducerConfig.configDef().defaultValues().get("delivery.timeout.ms")).longValue() + buffer, min));
    }

    public static void setConsumerRecordFormatter(Function<ConsumerRecord<?, ?>, String> formatter) {
        Assert.notNull(formatter, (String)"'formatter' cannot be null");
        crFormatter = formatter;
    }

    public static void setProducerRecordFormatter(Function<ProducerRecord<?, ?>, String> formatter) {
        Assert.notNull(formatter, (String)"'formatter' cannot be null");
        prFormatter = formatter;
    }

    public static String format(ConsumerRecord<?, ?> record) {
        return crFormatter.apply(record);
    }

    @Deprecated
    public static String format(ConsumerRecord<?, ?> record, boolean full) {
        if (full) {
            return record.toString();
        }
        return crFormatter.apply(record);
    }

    public static String format(ProducerRecord<?, ?> record) {
        return prFormatter.apply(record);
    }

    private KafkaUtils() {
    }
}

