/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.converter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.kafka.KafkaException;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;

public class ConversionException
extends KafkaException {
    private transient ConsumerRecord<?, ?> record;
    private transient List<ConsumerRecord<?, ?>> records = new ArrayList();
    private transient Message<?> message;

    public ConversionException(String message, Throwable cause) {
        super(message, cause);
        this.record = null;
        this.message = null;
    }

    public ConversionException(String message, ConsumerRecord<?, ?> record, Throwable cause) {
        super(message, cause);
        this.record = record;
        this.message = null;
    }

    public ConversionException(String message, List<ConsumerRecord<?, ?>> records, Throwable cause) {
        super(message, cause);
        this.record = null;
        this.records.addAll(records);
        this.message = null;
    }

    public ConversionException(String message, Message<?> msg, Throwable cause) {
        super(message, cause);
        this.record = null;
        this.message = msg;
    }

    @Nullable
    public ConsumerRecord<?, ?> getRecord() {
        return this.record;
    }

    public List<ConsumerRecord<?, ?>> getRecords() {
        return Collections.unmodifiableList(this.records);
    }

    @Nullable
    public Message<?> getMsg() {
        return this.message;
    }
}

