/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support;

import java.nio.ByteBuffer;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.util.Assert;

public class KafkaMessageHeaderAccessor
extends MessageHeaderAccessor {
    public KafkaMessageHeaderAccessor(Message<?> message) {
        super(message);
    }

    @Nullable
    public int getBlockingRetryDeliveryAttempt() {
        Assert.state((this.getHeader("kafka_deliveryAttempt") != null ? 1 : 0) != 0, (String)"Blocking delivery attempt header not present, see ContainerProperties.setDeliveryAttemptHeader() to enable");
        return this.getHeader("kafka_deliveryAttempt", Integer.class);
    }

    public int getNonBlockingRetryDeliveryAttempt() {
        return this.fromBytes("retry_topic-attempts");
    }

    private int fromBytes(String headerName) {
        byte[] header = this.getHeader(headerName, byte[].class);
        return header == null ? 1 : ByteBuffer.wrap(header).getInt();
    }

    @Nullable
    public <T> T getHeader(String key, Class<T> type) {
        Object value = this.getHeader(key);
        if (value == null) {
            return null;
        }
        if (!type.isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException("Incorrect type specified for header '" + key + "'. Expected [" + type + "] but actual type is [" + value.getClass() + "]");
        }
        return (T)value;
    }

    protected MessageHeaderAccessor createAccessor(Message<?> message) {
        return KafkaMessageHeaderAccessor.wrap(message);
    }

    public static KafkaMessageHeaderAccessor wrap(Message<?> message) {
        return new KafkaMessageHeaderAccessor(message);
    }
}

