/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener.adapter;

import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.kafka.listener.AcknowledgingConsumerAwareMessageListener;
import org.springframework.kafka.listener.MessageListener;
import org.springframework.kafka.listener.adapter.AbstractFilteringMessageListener;
import org.springframework.kafka.listener.adapter.RecordFilterStrategy;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.lang.Nullable;

public class FilteringMessageListenerAdapter<K, V>
extends AbstractFilteringMessageListener<K, V, MessageListener<K, V>>
implements AcknowledgingConsumerAwareMessageListener<K, V> {
    private final boolean ackDiscarded;

    public FilteringMessageListenerAdapter(MessageListener<K, V> delegate, RecordFilterStrategy<K, V> recordFilterStrategy) {
        super(delegate, recordFilterStrategy);
        this.ackDiscarded = false;
    }

    public FilteringMessageListenerAdapter(MessageListener<K, V> delegate, RecordFilterStrategy<K, V> recordFilterStrategy, boolean ackDiscarded) {
        super(delegate, recordFilterStrategy);
        this.ackDiscarded = ackDiscarded;
    }

    @Override
    public void onMessage(ConsumerRecord<K, V> consumerRecord, @Nullable Acknowledgment acknowledgment, Consumer<?, ?> consumer) {
        if (!this.filter(consumerRecord)) {
            switch (this.delegateType) {
                case ACKNOWLEDGING_CONSUMER_AWARE: {
                    ((MessageListener)this.delegate).onMessage(consumerRecord, acknowledgment, consumer);
                    break;
                }
                case ACKNOWLEDGING: {
                    ((MessageListener)this.delegate).onMessage(consumerRecord, acknowledgment);
                    break;
                }
                case CONSUMER_AWARE: {
                    ((MessageListener)this.delegate).onMessage(consumerRecord, consumer);
                    break;
                }
                case SIMPLE: {
                    ((MessageListener)this.delegate).onMessage(consumerRecord);
                }
            }
        } else {
            this.ackFilteredIfNecessary(acknowledgment);
        }
    }

    private void ackFilteredIfNecessary(@Nullable Acknowledgment acknowledgment) {
        switch (this.delegateType) {
            case ACKNOWLEDGING_CONSUMER_AWARE: 
            case ACKNOWLEDGING: {
                if (!this.ackDiscarded || acknowledgment == null) break;
                acknowledgment.acknowledge();
                break;
            }
        }
    }

    @Override
    public void onMessage(ConsumerRecord<K, V> data) {
        this.onMessage(data, (Acknowledgment)null, (Consumer<?, ?>)null);
    }

    @Override
    public void onMessage(ConsumerRecord<K, V> data, Acknowledgment acknowledgment) {
        this.onMessage(data, acknowledgment, (Consumer<?, ?>)null);
    }

    @Override
    public void onMessage(ConsumerRecord<K, V> data, Consumer<?, ?> consumer) {
        this.onMessage(data, (Acknowledgment)null, consumer);
    }
}

