/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.retrytopic;

import java.util.Objects;
import java.util.function.BiPredicate;
import org.springframework.kafka.core.KafkaOperations;
import org.springframework.kafka.retrytopic.DltStrategy;
import org.springframework.lang.Nullable;

public class DestinationTopic {
    private final String destinationName;
    private final Properties properties;

    public DestinationTopic(String destinationName, Properties properties) {
        this.destinationName = destinationName;
        this.properties = properties;
    }

    public DestinationTopic(String destinationName, DestinationTopic sourceDestinationtopic, String suffix, Type type) {
        this.destinationName = destinationName;
        this.properties = new Properties(sourceDestinationtopic.properties, suffix, type);
    }

    public Long getDestinationDelay() {
        return this.properties.delayMs;
    }

    public Integer getDestinationPartitions() {
        return this.properties.numPartitions;
    }

    public boolean isAlwaysRetryOnDltFailure() {
        return DltStrategy.ALWAYS_RETRY_ON_ERROR.equals((Object)this.properties.dltStrategy);
    }

    public boolean isDltTopic() {
        return Type.DLT.equals((Object)this.properties.type);
    }

    public boolean isNoOpsTopic() {
        return Type.NO_OPS.equals((Object)this.properties.type);
    }

    public boolean isReusableRetryTopic() {
        return Type.REUSABLE_RETRY_TOPIC.equals((Object)this.properties.type);
    }

    public boolean isMainTopic() {
        return Type.MAIN.equals((Object)this.properties.type);
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public KafkaOperations<?, ?> getKafkaOperations() {
        return this.properties.kafkaOperations;
    }

    public boolean shouldRetryOn(Integer attempt, Throwable e) {
        return this.properties.shouldRetryOn.test(attempt, e);
    }

    public String toString() {
        return "DestinationTopic{destinationName='" + this.destinationName + "', properties=" + this.properties + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DestinationTopic that = (DestinationTopic)o;
        return this.destinationName.equals(that.destinationName) && this.properties.equals(that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.destinationName, this.properties);
    }

    public long getDestinationTimeout() {
        return this.properties.timeout;
    }

    public static class Properties {
        private final long delayMs;
        private final String suffix;
        private final Type type;
        private final int maxAttempts;
        private final int numPartitions;
        private final DltStrategy dltStrategy;
        private final KafkaOperations<?, ?> kafkaOperations;
        private final BiPredicate<Integer, Throwable> shouldRetryOn;
        private final long timeout;
        @Nullable
        private final Boolean autoStartDltHandler;

        public Properties(long delayMs, String suffix, Type type, int maxAttempts, int numPartitions, DltStrategy dltStrategy, KafkaOperations<?, ?> kafkaOperations, BiPredicate<Integer, Throwable> shouldRetryOn, long timeout) {
            this(delayMs, suffix, type, maxAttempts, numPartitions, dltStrategy, kafkaOperations, shouldRetryOn, timeout, null);
        }

        public Properties(Properties sourceProperties, String suffix, Type type) {
            this(sourceProperties.delayMs, suffix, type, sourceProperties.maxAttempts, sourceProperties.numPartitions, sourceProperties.dltStrategy, sourceProperties.kafkaOperations, sourceProperties.shouldRetryOn, sourceProperties.timeout, null);
        }

        public Properties(long delayMs, String suffix, Type type, int maxAttempts, int numPartitions, DltStrategy dltStrategy, KafkaOperations<?, ?> kafkaOperations, BiPredicate<Integer, Throwable> shouldRetryOn, long timeout, @Nullable Boolean autoStartDltHandler) {
            this.delayMs = delayMs;
            this.suffix = suffix;
            this.type = type;
            this.maxAttempts = maxAttempts;
            this.numPartitions = numPartitions;
            this.dltStrategy = dltStrategy;
            this.kafkaOperations = kafkaOperations;
            this.shouldRetryOn = shouldRetryOn;
            this.timeout = timeout;
            this.autoStartDltHandler = autoStartDltHandler;
        }

        public boolean isDltTopic() {
            return Type.DLT.equals((Object)this.type);
        }

        public boolean isRetryTopic() {
            return Type.RETRY.equals((Object)this.type) || Type.REUSABLE_RETRY_TOPIC.equals((Object)this.type);
        }

        public String suffix() {
            return this.suffix;
        }

        public long delay() {
            return this.delayMs;
        }

        public int numPartitions() {
            return this.numPartitions;
        }

        @Nullable
        public Boolean autoStartDltHandler() {
            return this.autoStartDltHandler;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Properties that = (Properties)o;
            return this.delayMs == that.delayMs && this.maxAttempts == that.maxAttempts && this.numPartitions == that.numPartitions && this.suffix.equals(that.suffix) && this.type == that.type && this.dltStrategy == that.dltStrategy && this.kafkaOperations.equals(that.kafkaOperations);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.delayMs, this.suffix, this.type, this.maxAttempts, this.numPartitions, this.dltStrategy, this.kafkaOperations});
        }

        public String toString() {
            return "Properties{delayMs=" + this.delayMs + ", suffix='" + this.suffix + "', type=" + this.type + ", maxAttempts=" + this.maxAttempts + ", numPartitions=" + this.numPartitions + ", dltStrategy=" + this.dltStrategy + ", kafkaOperations=" + this.kafkaOperations + ", shouldRetryOn=" + this.shouldRetryOn + ", timeout=" + this.timeout + "}";
        }

        public boolean isMainEndpoint() {
            return Type.MAIN.equals((Object)this.type);
        }
    }

    static enum Type {
        MAIN,
        RETRY,
        REUSABLE_RETRY_TOPIC,
        DLT,
        NO_OPS;

    }
}

