/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.security.jaas;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.util.Assert;

public class KafkaJaasLoginModuleInitializer
implements SmartInitializingSingleton,
DisposableBean {
    public static final String KAFKA_CLIENT_CONTEXT_NAME = "KafkaClient";
    private final boolean ignoreJavaLoginConfigParamSystemProperty;
    private final File placeholderJaasConfiguration;
    private final Map<String, String> options = new HashMap<String, String>();
    private String loginModule = "com.sun.security.auth.module.Krb5LoginModule";
    private AppConfigurationEntry.LoginModuleControlFlag controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;

    public KafkaJaasLoginModuleInitializer() throws IOException {
        this.ignoreJavaLoginConfigParamSystemProperty = System.getProperty("java.security.auth.login.config") == null;
        this.placeholderJaasConfiguration = File.createTempFile("kafka-client-jaas-config-placeholder", "conf");
        this.placeholderJaasConfiguration.deleteOnExit();
    }

    public void setLoginModule(String loginModule) {
        Assert.notNull((Object)loginModule, (String)"cannot be null");
        this.loginModule = loginModule;
    }

    public void setControlFlag(ControlFlag controlFlag) {
        Assert.notNull((Object)((Object)controlFlag), (String)"cannot be null");
        this.controlFlag = switch (controlFlag) {
            case ControlFlag.OPTIONAL -> AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
            case ControlFlag.REQUIRED -> AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
            case ControlFlag.REQUISITE -> AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
            case ControlFlag.SUFFICIENT -> AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
            default -> throw new IllegalArgumentException(controlFlag + " is not a supported control flag");
        };
    }

    public void setOptions(Map<String, String> options) {
        this.options.clear();
        this.options.putAll(options);
    }

    public void afterSingletonsInstantiated() {
        if (this.ignoreJavaLoginConfigParamSystemProperty) {
            HashMap<String, AppConfigurationEntry[]> configurationEntries = new HashMap<String, AppConfigurationEntry[]>();
            AppConfigurationEntry kafkaClientConfigurationEntry = new AppConfigurationEntry(this.loginModule, this.controlFlag, this.options);
            configurationEntries.put(KAFKA_CLIENT_CONTEXT_NAME, new AppConfigurationEntry[]{kafkaClientConfigurationEntry});
            Configuration.setConfiguration(new InternalConfiguration(configurationEntries, Configuration.getConfiguration()));
            if (this.placeholderJaasConfiguration != null) {
                System.setProperty("java.security.auth.login.config", this.placeholderJaasConfiguration.getAbsolutePath());
            }
        }
    }

    public void destroy() {
        if (this.ignoreJavaLoginConfigParamSystemProperty) {
            System.clearProperty("java.security.auth.login.config");
        }
    }

    public static enum ControlFlag {
        REQUIRED,
        REQUISITE,
        SUFFICIENT,
        OPTIONAL;

    }

    private static class InternalConfiguration
    extends Configuration {
        private final Map<String, AppConfigurationEntry[]> configurationEntries;
        private final Configuration delegate;

        InternalConfiguration(Map<String, AppConfigurationEntry[]> configurationEntries, Configuration delegate) {
            Assert.notNull(configurationEntries, (String)"'configurationEntries' cannot be null");
            Assert.notEmpty(configurationEntries, (String)"'configurationEntries' cannot be empty");
            this.configurationEntries = configurationEntries;
            this.delegate = delegate;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            AppConfigurationEntry[] conf = this.delegate == null ? null : this.delegate.getAppConfigurationEntry(name);
            return conf != null ? conf : this.configurationEntries.get(name);
        }
    }
}

