/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.springframework.classify.BinaryExceptionClassifier;
import org.springframework.core.log.LogAccessor;
import org.springframework.kafka.KafkaException;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.listener.CommonErrorHandler;
import org.springframework.kafka.listener.ListenerExecutionFailedException;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.kafka.listener.RetryListener;
import org.springframework.kafka.listener.TimestampedException;
import org.springframework.kafka.support.KafkaUtils;
import org.springframework.kafka.support.serializer.ErrorHandlingDeserializer;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.backoff.BackOff;

public final class ErrorHandlingUtils {
    static Runnable NO_OP = () -> {};

    private ErrorHandlingUtils() {
    }

    /*
     * Exception decompiling
     */
    public static void retryBatch(Exception thrownException, ConsumerRecords<?, ?> records, Consumer<?, ?> consumer, MessageListenerContainer container, Runnable invokeListener, BackOff backOff, CommonErrorHandler seeker, BiConsumer<ConsumerRecords<?, ?>, Exception> recoverer, LogAccessor logger, KafkaException.Level logLevel, List<RetryListener> retryListeners, BinaryExceptionClassifier classifier, boolean reClassifyOnExceptionChange) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void listen(List<RetryListener> listeners, ConsumerRecords<?, ?> records, Exception thrownException, int attempt) {
        listeners.forEach(listener -> listener.failedDelivery(records, thrownException, attempt));
    }

    public static String recordsToString(ConsumerRecords<?, ?> records) {
        return StreamSupport.stream(records.spliterator(), false).map(KafkaUtils::format).collect(Collectors.joining(","));
    }

    public static Exception unwrapIfNeeded(Exception exception) {
        Exception cause;
        Throwable throwable;
        Exception theEx = exception;
        if (theEx instanceof TimestampedException && (throwable = theEx.getCause()) instanceof Exception) {
            theEx = cause = (Exception)throwable;
        }
        if (theEx instanceof ListenerExecutionFailedException && (throwable = theEx.getCause()) instanceof Exception) {
            theEx = cause = (Exception)throwable;
        }
        return theEx;
    }

    public static Exception findRootCause(Exception exception) {
        Throwable throwable;
        Exception realException = exception;
        while ((realException instanceof ListenerExecutionFailedException || realException instanceof TimestampedException) && (throwable = realException.getCause()) instanceof Exception) {
            Exception cause;
            realException = cause = (Exception)throwable;
        }
        return realException;
    }

    public static <K, V> boolean checkDeserializer(ConsumerFactory<K, V> consumerFactory, Properties consumerOverrides, boolean isValue, ClassLoader classLoader) {
        Object deser = ErrorHandlingUtils.findDeserializerClass(consumerFactory, consumerOverrides, isValue);
        Class deserializer = null;
        if (deser instanceof Class) {
            Class deserClass;
            deserializer = deserClass = (Class)deser;
        } else if (deser instanceof String) {
            String str = (String)deser;
            try {
                deserializer = ClassUtils.forName((String)str, (ClassLoader)classLoader);
            }
            catch (ClassNotFoundException | LinkageError e) {
                throw new IllegalStateException(e);
            }
        } else if (deser != null) {
            throw new IllegalStateException("Deserializer must be a class or class name, not a " + deser.getClass());
        }
        return deserializer != null && ErrorHandlingDeserializer.class.isAssignableFrom(deserializer);
    }

    @Nullable
    private static <K, V> Object findDeserializerClass(ConsumerFactory<K, V> consumerFactory, Properties consumerOverrides, boolean isValue) {
        Object configuredDeserializer;
        Map<String, Object> props = consumerFactory.getConfigurationProperties();
        Object object = configuredDeserializer = isValue ? consumerFactory.getValueDeserializer() : consumerFactory.getKeyDeserializer();
        if (configuredDeserializer == null) {
            Object deser = consumerOverrides.get(isValue ? "value.deserializer" : "key.deserializer");
            if (deser == null) {
                deser = props.get(isValue ? "value.deserializer" : "key.deserializer");
            }
            return deser;
        }
        return configuredDeserializer.getClass();
    }

    private static /* synthetic */ void lambda$retryBatch$4(ConsumerRecords records, Exception thrownException, Exception ex, RetryListener listener) {
        listener.recoveryFailed(records, thrownException, ex);
    }

    private static /* synthetic */ void lambda$retryBatch$3(ConsumerRecords records, Exception finalRecoveryException, RetryListener listener) {
        listener.recovered(records, finalRecoveryException);
    }

    private static /* synthetic */ CharSequence lambda$retryBatch$2(String toLog) {
        return "Retry failed for: " + toLog;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static /* synthetic */ Boolean lambda$retryBatch$1(MessageListenerContainer container, ConsumerRecords records) {
        boolean bl;
        if (container.isRunning() && !container.isPauseRequested()) {
            if (records.partitions().stream().noneMatch(container::isPartitionPauseRequested)) {
                bl = true;
                return bl;
            }
        }
        bl = false;
        return bl;
    }
}

