/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.springframework.kafka.KafkaException;
import org.springframework.kafka.core.KafkaOperations;
import org.springframework.kafka.listener.AfterRollbackProcessor;
import org.springframework.kafka.listener.BackOffHandler;
import org.springframework.kafka.listener.ContainerProperties;
import org.springframework.kafka.listener.FailedRecordProcessor;
import org.springframework.kafka.listener.ListenerUtils;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.kafka.listener.SeekUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.backoff.BackOff;
import org.springframework.util.backoff.BackOffExecution;

public class DefaultAfterRollbackProcessor<K, V>
extends FailedRecordProcessor
implements AfterRollbackProcessor<K, V> {
    private final Map<Thread, BackOffExecution> backOffs = new ConcurrentHashMap<Thread, BackOffExecution>();
    private final Map<Thread, Long> lastIntervals = new ConcurrentHashMap<Thread, Long>();
    private final BackOff backOff;
    private final KafkaOperations<?, ?> kafkaTemplate;
    private final BiConsumer<ConsumerRecords<?, ?>, Exception> recoverer;

    public DefaultAfterRollbackProcessor() {
        this(null, (BackOff)SeekUtils.DEFAULT_BACK_OFF);
    }

    public DefaultAfterRollbackProcessor(BackOff backOff) {
        this(null, backOff);
    }

    public DefaultAfterRollbackProcessor(BiConsumer<ConsumerRecord<?, ?>, Exception> recoverer) {
        this(recoverer, (BackOff)SeekUtils.DEFAULT_BACK_OFF);
    }

    public DefaultAfterRollbackProcessor(@Nullable BiConsumer<ConsumerRecord<?, ?>, Exception> recoverer, BackOff backOff) {
        this(recoverer, backOff, null, false);
    }

    public DefaultAfterRollbackProcessor(@Nullable BiConsumer<ConsumerRecord<?, ?>, Exception> recoverer, BackOff backOff, @Nullable KafkaOperations<?, ?> kafkaOperations, boolean commitRecovered) {
        this(recoverer, backOff, null, kafkaOperations, commitRecovered);
    }

    public DefaultAfterRollbackProcessor(@Nullable BiConsumer<ConsumerRecord<?, ?>, Exception> recoverer, BackOff backOff, @Nullable BackOffHandler backOffHandler, @Nullable KafkaOperations<?, ?> kafkaOperations, boolean commitRecovered) {
        super(recoverer, backOff, backOffHandler);
        this.kafkaTemplate = kafkaOperations;
        super.setCommitRecovered(commitRecovered);
        this.checkConfig();
        this.backOff = backOff;
        this.recoverer = (crs, ex) -> {
            if (recoverer != null && !crs.isEmpty()) {
                crs.spliterator().forEachRemaining(rec -> recoverer.accept((ConsumerRecord<?, ?>)rec, (Exception)ex));
            }
        };
    }

    private void checkConfig() {
        Assert.isTrue((!this.isCommitRecovered() || this.kafkaTemplate != null ? 1 : 0) != 0, (String)"A KafkaOperations is required when 'commitRecovered' is true");
    }

    @Override
    public void process(List<ConsumerRecord<K, V>> records, Consumer<K, V> consumer, @Nullable MessageListenerContainer container, Exception exception, boolean recoverable, ContainerProperties.EOSMode eosMode) {
        if (SeekUtils.doSeeks(records, consumer, exception, recoverable, this.getFailureTracker(), container, this.logger) && this.isCommitRecovered() && this.kafkaTemplate.isTransactional()) {
            ConsumerRecord<?, ?> skipped = records.get(0);
            this.kafkaTemplate.sendOffsetsToTransaction(Collections.singletonMap(new TopicPartition(skipped.topic(), skipped.partition()), DefaultAfterRollbackProcessor.createOffsetAndMetadata(container, skipped.offset() + 1L)), consumer.groupMetadata());
        }
        if (!recoverable && this.backOff != null) {
            try {
                ListenerUtils.unrecoverableBackOff(this.backOff, this.backOffs, this.lastIntervals, container);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void processBatch(ConsumerRecords<K, V> records, List<ConsumerRecord<K, V>> recordList, Consumer<K, V> consumer, @Nullable MessageListenerContainer container, Exception exception, boolean recoverable, ContainerProperties.EOSMode eosMode) {
        if (recoverable && this.isCommitRecovered()) {
            long nextBackOff = ListenerUtils.nextBackOff(this.backOff, this.backOffs);
            if (nextBackOff != -1L) {
                SeekUtils.doSeeksToBegin(recordList, consumer, this.logger);
                try {
                    ListenerUtils.stoppableSleep(container, nextBackOff);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                return;
            }
            try {
                this.recoverer.accept(records, exception);
                HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
                records.forEach(rec -> offsets.put(new TopicPartition(rec.topic(), rec.partition()), ListenerUtils.createOffsetAndMetadata(container, rec.offset() + 1L)));
                if (offsets.size() > 0 && this.kafkaTemplate != null && this.kafkaTemplate.isTransactional()) {
                    this.kafkaTemplate.sendOffsetsToTransaction(offsets, consumer.groupMetadata());
                }
                this.clearThreadState();
            }
            catch (Exception ex) {
                SeekUtils.doSeeksToBegin(recordList, consumer, this.logger);
                this.logger.error((Throwable)ex, (CharSequence)"Recoverer threw an exception; re-seeking batch");
                throw ex;
            }
            return;
        }
        try {
            this.process(recordList, consumer, container, exception, false, eosMode);
        }
        catch (KafkaException ke) {
            ke.selfLog("AfterRollbackProcessor threw an exception", this.logger);
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex, (CharSequence)"AfterRollbackProcessor threw an exception");
        }
    }

    @Override
    public boolean isProcessInTransaction() {
        return this.isCommitRecovered();
    }

    @Override
    public void clearThreadState() {
        super.clearThreadState();
        Thread currentThread = Thread.currentThread();
        this.backOffs.remove(currentThread);
        this.lastIntervals.remove(currentThread);
    }

    private static OffsetAndMetadata createOffsetAndMetadata(@Nullable MessageListenerContainer container, long offset) {
        if (container == null) {
            return new OffsetAndMetadata(offset);
        }
        return ListenerUtils.createOffsetAndMetadata(container, offset);
    }
}

