/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener.adapter;

import org.springframework.kafka.listener.adapter.AdapterUtils;
import org.springframework.kafka.listener.adapter.DelegatingInvocableHandler;
import org.springframework.kafka.listener.adapter.InvocationResult;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;

public class HandlerAdapter {
    private final InvocableHandlerMethod invokerHandlerMethod;
    private final DelegatingInvocableHandler delegatingHandler;
    private final boolean asyncReplies;

    public HandlerAdapter(InvocableHandlerMethod invokerHandlerMethod) {
        this.invokerHandlerMethod = invokerHandlerMethod;
        this.delegatingHandler = null;
        this.asyncReplies = AdapterUtils.isAsyncReply(invokerHandlerMethod.getMethod().getReturnType());
    }

    public HandlerAdapter(DelegatingInvocableHandler delegatingHandler) {
        this.invokerHandlerMethod = null;
        this.delegatingHandler = delegatingHandler;
        this.asyncReplies = delegatingHandler.isAsyncReplies();
    }

    public boolean isAsyncReplies() {
        return this.asyncReplies;
    }

    @Nullable
    public Object invoke(Message<?> message, Object ... providedArgs) throws Exception {
        if (this.invokerHandlerMethod != null) {
            return this.invokerHandlerMethod.invoke(message, providedArgs);
        }
        if (this.delegatingHandler.hasDefaultHandler()) {
            Object[] args = new Object[providedArgs.length + 1];
            args[0] = message.getPayload();
            System.arraycopy(providedArgs, 0, args, 1, providedArgs.length);
            return this.delegatingHandler.invoke(message, args);
        }
        return this.delegatingHandler.invoke(message, providedArgs);
    }

    public String getMethodAsString(Object payload) {
        if (this.invokerHandlerMethod != null) {
            return this.invokerHandlerMethod.getMethod().toGenericString();
        }
        return this.delegatingHandler.getMethodNameFor(payload);
    }

    public Object getBean() {
        if (this.invokerHandlerMethod != null) {
            return this.invokerHandlerMethod.getBean();
        }
        return this.delegatingHandler.getBean();
    }

    @Nullable
    public InvocationResult getInvocationResultFor(Object result, @Nullable Object inboundPayload) {
        if (this.delegatingHandler != null && inboundPayload != null) {
            return this.delegatingHandler.getInvocationResultFor(result, inboundPayload);
        }
        return null;
    }
}

