/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import org.apache.kafka.common.TopicPartition;
import org.springframework.lang.Nullable;

public interface ConsumerSeekAware {
    default public void registerSeekCallback(ConsumerSeekCallback callback) {
    }

    default public void onPartitionsAssigned(Map<TopicPartition, Long> assignments, ConsumerSeekCallback callback) {
    }

    default public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
    }

    default public void onIdleContainer(Map<TopicPartition, Long> assignments, ConsumerSeekCallback callback) {
    }

    default public void onFirstPoll() {
    }

    default public void unregisterSeekCallback() {
    }

    public static interface ConsumerSeekCallback {
        public void seek(String var1, int var2, long var3);

        public void seek(String var1, int var2, Function<Long, Long> var3);

        public void seekToBeginning(String var1, int var2);

        default public void seekToBeginning(Collection<TopicPartition> partitions) {
            throw new UnsupportedOperationException();
        }

        public void seekToEnd(String var1, int var2);

        default public void seekToEnd(Collection<TopicPartition> partitions) {
            throw new UnsupportedOperationException();
        }

        public void seekRelative(String var1, int var2, long var3, boolean var5);

        public void seekToTimestamp(String var1, int var2, long var3);

        public void seekToTimestamp(Collection<TopicPartition> var1, long var2);

        @Nullable
        default public String getGroupId() {
            return null;
        }
    }
}

