/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.micrometer;

import io.micrometer.observation.transport.ReceiverContext;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Header;
import org.springframework.lang.Nullable;

public class KafkaRecordReceiverContext
extends ReceiverContext<ConsumerRecord<?, ?>> {
    private final String listenerId;
    private final String clientId;
    private final String groupId;
    private final ConsumerRecord<?, ?> record;

    public KafkaRecordReceiverContext(ConsumerRecord<?, ?> record, String listenerId, Supplier<String> clusterId) {
        this(record, listenerId, null, null, clusterId);
    }

    public KafkaRecordReceiverContext(ConsumerRecord<?, ?> record, String listenerId, String clientId, String groupId, Supplier<String> clusterId) {
        super((carrier, key) -> {
            Header header = carrier.headers().lastHeader(key);
            if (header == null || header.value() == null) {
                return null;
            }
            return new String(header.value(), StandardCharsets.UTF_8);
        });
        this.setCarrier(record);
        this.record = record;
        this.listenerId = listenerId;
        this.clientId = clientId;
        this.groupId = groupId;
        String cluster = clusterId.get();
        this.setRemoteServiceName("Apache Kafka" + (String)(cluster != null ? ": " + cluster : ""));
    }

    public String getListenerId() {
        return this.listenerId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    @Nullable
    public String getClientId() {
        return this.clientId;
    }

    public String getSource() {
        return this.record.topic();
    }

    public ConsumerRecord<?, ?> getRecord() {
        return this.record;
    }

    public String getPartition() {
        return Integer.toString(this.record.partition());
    }

    public String getOffset() {
        return Long.toString(this.record.offset());
    }
}

