/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.nio.ByteBuffer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.springframework.kafka.listener.RetryListener;

public class DeliveryAttemptAwareRetryListener
implements RetryListener {
    @Override
    public void failedDelivery(ConsumerRecord<?, ?> record, Exception ex, int deliveryAttempt) {
    }

    @Override
    public void failedDelivery(ConsumerRecords<?, ?> records, Exception ex, int deliveryAttempt) {
        for (ConsumerRecord record : records) {
            record.headers().remove("kafka_deliveryAttempt");
            byte[] buff = new byte[4];
            ByteBuffer bb = ByteBuffer.wrap(buff);
            bb.putInt(deliveryAttempt);
            record.headers().add((Header)new RecordHeader("kafka_deliveryAttempt", buff));
        }
    }
}

