/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.core;

import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.kafka.core.NoProducerAvailableException;
import org.springframework.kafka.core.TransactionIdSuffixStrategy;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class DefaultTransactionIdSuffixStrategy
implements TransactionIdSuffixStrategy {
    private final AtomicInteger transactionIdSuffix = new AtomicInteger();
    private final Map<String, BlockingQueue<String>> suffixCache = new ConcurrentHashMap<String, BlockingQueue<String>>();
    private final int maxCache;

    public DefaultTransactionIdSuffixStrategy(int maxCache) {
        Assert.isTrue((maxCache >= 0 ? 1 : 0) != 0, (String)"'maxCache' must be greater than or equal to 0");
        this.maxCache = maxCache;
    }

    @Override
    public String acquireSuffix(String txIdPrefix) {
        Assert.notNull((Object)txIdPrefix, (String)"'txIdPrefix' must not be null");
        BlockingQueue<String> cache = this.getSuffixCache(txIdPrefix);
        if (cache == null) {
            return String.valueOf(this.transactionIdSuffix.getAndIncrement());
        }
        String suffix = (String)cache.poll();
        if (suffix == null) {
            throw new NoProducerAvailableException("No available transaction producer", txIdPrefix);
        }
        return suffix;
    }

    @Override
    public void releaseSuffix(String txIdPrefix, String suffix) {
        Assert.notNull((Object)txIdPrefix, (String)"'txIdPrefix' must not be null");
        Assert.notNull((Object)suffix, (String)"'suffix' must not be null");
        if (this.maxCache <= 0) {
            return;
        }
        BlockingQueue<String> queue = this.getSuffixCache(txIdPrefix);
        if (queue != null && !queue.contains(suffix)) {
            queue.add(suffix);
        }
    }

    @Nullable
    private BlockingQueue<String> getSuffixCache(String txIdPrefix) {
        if (this.maxCache <= 0) {
            return null;
        }
        return this.suffixCache.computeIfAbsent(txIdPrefix, txId -> {
            LinkedBlockingQueue<String> queue = new LinkedBlockingQueue<String>();
            for (int suffix = 0; suffix < this.maxCache; ++suffix) {
                queue.add(String.valueOf(this.transactionIdSuffix.getAndIncrement()));
            }
            return queue;
        });
    }
}

