/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.log.LogAccessor;
import org.springframework.kafka.core.ShareConsumerFactory;
import org.springframework.kafka.listener.ContainerProperties;
import org.springframework.kafka.listener.GenericMessageListener;
import org.springframework.kafka.listener.GenericMessageListenerContainer;
import org.springframework.kafka.support.TopicPartitionOffset;
import org.springframework.util.Assert;

public abstract class AbstractShareKafkaMessageListenerContainer<K, V>
implements GenericMessageListenerContainer<K, V>,
BeanNameAware,
ApplicationEventPublisherAware,
ApplicationContextAware {
    public static final int DEFAULT_PHASE = 2147483547;
    protected final ShareConsumerFactory<K, V> shareConsumerFactory;
    protected final LogAccessor logger = new LogAccessor(LogFactory.getLog(this.getClass()));
    private final ContainerProperties containerProperties;
    protected final ReentrantLock lifecycleLock = new ReentrantLock();
    private String beanName = "noBeanNameSet";
    private @Nullable ApplicationEventPublisher applicationEventPublisher;
    private boolean autoStartup = true;
    private int phase = 2147483547;
    private @Nullable ApplicationContext applicationContext;
    private volatile boolean running = false;

    protected AbstractShareKafkaMessageListenerContainer(ShareConsumerFactory<? super K, ? super V> shareConsumerFactory, ContainerProperties containerProperties) {
        Assert.notNull((Object)containerProperties, (String)"'containerProperties' cannot be null");
        Assert.notNull(shareConsumerFactory, (String)"'shareConsumerFactory' cannot be null");
        this.shareConsumerFactory = shareConsumerFactory;
        String @Nullable [] topics = containerProperties.getTopics();
        if (topics != null) {
            this.containerProperties = new ContainerProperties(topics);
        } else {
            Pattern topicPattern = containerProperties.getTopicPattern();
            if (topicPattern != null) {
                this.containerProperties = new ContainerProperties(topicPattern);
            } else {
                TopicPartitionOffset @Nullable [] topicPartitions = containerProperties.getTopicPartitions();
                if (topicPartitions != null) {
                    this.containerProperties = new ContainerProperties(topicPartitions);
                } else {
                    throw new IllegalStateException("topics, topicPattern, or topicPartitions must be provided");
                }
            }
        }
        BeanUtils.copyProperties((Object)containerProperties, (Object)this.containerProperties, (String[])new String[]{"topics", "topicPartitions", "topicPattern"});
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public @Nullable ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public @Nullable ApplicationEventPublisher getApplicationEventPublisher() {
        return this.applicationEventPublisher;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    @Override
    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public int getPhase() {
        return this.phase;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public void start() {
        this.lifecycleLock.lock();
        try {
            if (!this.isRunning()) {
                Assert.state((boolean)(this.containerProperties.getMessageListener() instanceof GenericMessageListener), () -> "A " + GenericMessageListener.class.getName() + " implementation must be provided");
                this.doStart();
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public void stop() {
        this.lifecycleLock.lock();
        try {
            if (this.isRunning()) {
                this.doStop();
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    protected void setRunning(boolean running) {
        this.running = running;
    }

    @Override
    public ContainerProperties getContainerProperties() {
        return this.containerProperties;
    }

    @Override
    public @Nullable String getGroupId() {
        return this.containerProperties.getGroupId() == null ? (String)this.shareConsumerFactory.getConfigurationProperties().get("group.id") : this.containerProperties.getGroupId();
    }

    @Override
    public String getListenerId() {
        return this.beanName;
    }

    @Override
    public void setupMessageListener(Object messageListener) {
        this.containerProperties.setMessageListener(messageListener);
    }

    protected abstract void doStart();

    protected abstract void doStop();

    @Override
    public void destroy() {
        this.stop();
    }
}

