/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.serializer;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.function.Function;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;
import org.jspecify.annotations.Nullable;
import org.springframework.core.retry.RetryException;
import org.springframework.core.retry.RetryOperations;
import org.springframework.core.retry.Retryable;
import org.springframework.util.Assert;

public class RetryingDeserializer<T>
implements Deserializer<T> {
    private final Deserializer<T> delegate;
    private final RetryOperations retryOperations;
    private @Nullable Function<RetryException, T> recoveryCallback;

    public RetryingDeserializer(Deserializer<T> delegate, RetryOperations retryOperations) {
        Assert.notNull(delegate, (String)"the 'delegate' deserializer cannot be null");
        Assert.notNull((Object)retryOperations, (String)"the 'retryOperations' deserializer cannot be null");
        this.delegate = delegate;
        this.retryOperations = retryOperations;
    }

    public void setRecoveryCallback(Function<RetryException, T> recoveryCallback) {
        this.recoveryCallback = recoveryCallback;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.delegate.configure(configs, isKey);
    }

    public @Nullable T deserialize(String topic, byte[] data) {
        return this.execute(() -> this.delegate.deserialize(topic, data));
    }

    public @Nullable T deserialize(String topic, Headers headers, byte[] data) {
        return this.execute(() -> this.delegate.deserialize(topic, headers, data));
    }

    public @Nullable T deserialize(String topic, Headers headers, ByteBuffer data) {
        return this.execute(() -> this.delegate.deserialize(topic, headers, data));
    }

    public void close() {
        this.delegate.close();
    }

    private @Nullable T execute(Retryable<T> retryable) {
        try {
            return (T)this.retryOperations.execute(retryable);
        }
        catch (RetryException ex) {
            if (this.recoveryCallback != null) {
                return this.recoveryCallback.apply(ex);
            }
            Throwable cause = ex.getCause();
            if (cause instanceof RuntimeException) {
                RuntimeException runtimeEx = (RuntimeException)cause;
                throw runtimeEx;
            }
            throw new IllegalStateException(cause);
        }
    }
}

