/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.core;

import java.net.URI;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttributes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.core.LdapAttribute;
import sun.misc.BASE64Encoder;

public class LdapAttributes
extends BasicAttributes {
    private static final long serialVersionUID = 97903297123869138L;
    private static Log log = LogFactory.getLog(LdapAttributes.class);
    private static final String SAFE_CHAR = "[\\p{ASCII}&&[^\\x00\\x0A\\x0D]]";
    private static final String SAFE_INIT_CHAR = "[\\p{ASCII}&&[^ \\x00\\x0A\\x0D\\x3A\\x3C]]";
    protected DistinguishedName dn = new DistinguishedName();

    public LdapAttributes() {
    }

    public LdapAttributes(DistinguishedName dn) {
        this.dn = dn;
    }

    public LdapAttributes(boolean ignoreCase) {
        super(ignoreCase);
    }

    public LdapAttributes(DistinguishedName dn, boolean ignoreCase) {
        super(ignoreCase);
        this.dn = dn;
    }

    public LdapAttributes(String attrID, Object val) {
        this.put(new LdapAttribute(attrID, val));
    }

    public LdapAttributes(DistinguishedName dn, String attrID, Object val) {
        this.dn = dn;
        this.put(new LdapAttribute(attrID, val));
    }

    public LdapAttributes(String attrID, Object val, boolean ignoreCase) {
        this.put(new LdapAttribute(attrID, val, ignoreCase));
    }

    public LdapAttributes(DistinguishedName dn, String attrID, Object val, boolean ignoreCase) {
        this.dn = dn;
        this.put(new LdapAttribute(attrID, val, ignoreCase));
    }

    public DistinguishedName getDN() {
        return this.dn;
    }

    public void setDN(DistinguishedName dn) {
        this.dn = dn;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        try {
            DistinguishedName dn = this.getDN();
            if (!dn.toString().matches("[\\p{ASCII}&&[^ \\x00\\x0A\\x0D\\x3A\\x3C]][\\p{ASCII}&&[^\\x00\\x0A\\x0D]]*")) {
                sb.append("dn:: " + new BASE64Encoder().encode(dn.toString().getBytes()) + "\n");
            } else {
                sb.append("dn: " + this.getDN() + "\n");
            }
            NamingEnumeration<Attribute> attributes = this.getAll();
            while (attributes.hasMore()) {
                Attribute attribute = attributes.next();
                NamingEnumeration<?> values = attribute.getAll();
                while (values.hasMore()) {
                    Object value = values.next();
                    if (value instanceof String) {
                        sb.append(attribute.getID() + ": " + (String)value + "\n");
                        continue;
                    }
                    if (value instanceof byte[]) {
                        sb.append(attribute.getID() + ":: " + new BASE64Encoder().encode((byte[])value) + "\n");
                        continue;
                    }
                    if (value instanceof URI) {
                        sb.append(attribute.getID() + ":< " + (URI)value + "\n");
                        continue;
                    }
                    sb.append(attribute.getID() + ": " + value + "\n");
                }
            }
        }
        catch (NamingException e) {
            log.error((Object)"Error formating attributes for output.", (Throwable)e);
            sb = new StringBuilder();
        }
        return sb.toString();
    }
}

