/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.odm.core.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import javax.naming.Name;
import org.springframework.ldap.odm.annotations.Attribute;
import org.springframework.ldap.odm.annotations.Id;
import org.springframework.ldap.odm.core.impl.CaseIgnoreString;
import org.springframework.ldap.odm.core.impl.MetaDataException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AttributeMetaData {
    private static final CaseIgnoreString OBJECT_CLASS_ATTRIBUTE_CI = new CaseIgnoreString("objectclass");
    private CaseIgnoreString name;
    private String syntax;
    private boolean isBinary;
    private final Field field;
    private Class<?> valueClass;
    private boolean isId;
    private boolean isList;
    private boolean isObjectClass;

    private boolean processAttributeAnnotation(Field field) {
        this.syntax = "";
        this.isBinary = false;
        this.name = new CaseIgnoreString(field.getName());
        boolean foundAnnotation = false;
        Attribute attribute = field.getAnnotation(Attribute.class);
        if (attribute != null) {
            foundAnnotation = true;
            String localAttributeName = attribute.name();
            if (localAttributeName != null && localAttributeName.length() > 0) {
                this.name = new CaseIgnoreString(localAttributeName);
            }
            this.syntax = attribute.syntax();
            this.isBinary = attribute.type() == Attribute.Type.BINARY;
        }
        this.isObjectClass = this.name.equals(OBJECT_CLASS_ATTRIBUTE_CI);
        return foundAnnotation;
    }

    private void determineFieldType(Field field) {
        Class<?> fieldType = field.getType();
        if (Set.class.isAssignableFrom(fieldType)) {
            throw new MetaDataException(String.format("Only lists are allowed for multivlaued attributes, errpr in field %1$s in Entry class %2$s", field, field.getDeclaringClass()));
        }
        this.isList = List.class.isAssignableFrom(fieldType);
        this.valueClass = null;
        if (!this.isList) {
            this.valueClass = fieldType;
        } else {
            ParameterizedType paramType;
            try {
                paramType = (ParameterizedType)field.getGenericType();
            }
            catch (ClassCastException e) {
                throw new MetaDataException(String.format("Can't determine destination type for field %1$s in Entry class %2$s", field, field.getDeclaringClass()), e);
            }
            Type[] actualParamArguments = paramType.getActualTypeArguments();
            if (actualParamArguments.length == 1) {
                Type type;
                if (actualParamArguments[0] instanceof Class) {
                    this.valueClass = (Class)actualParamArguments[0];
                } else if (actualParamArguments[0] instanceof GenericArrayType && (type = ((GenericArrayType)actualParamArguments[0]).getGenericComponentType()) instanceof Class) {
                    this.valueClass = Array.newInstance((Class)type, 0).getClass();
                }
            }
        }
        if (this.valueClass == null) {
            throw new MetaDataException(String.format("Can't determine destination type for field %1$s in class %2$s", field, field.getDeclaringClass()));
        }
    }

    private boolean processIdAnnotation(Field field, Class<?> fieldType) {
        boolean bl = this.isId = field.getAnnotation(Id.class) != null;
        if (this.isId && !Name.class.isAssignableFrom(fieldType)) {
            throw new MetaDataException(String.format("The id field must be of type javax.naming.Name or a subclass that of in Entry class %1$s", field.getDeclaringClass()));
        }
        return this.isId;
    }

    public AttributeMetaData(Field field) {
        this.field = field;
        this.determineFieldType(field);
        boolean foundAttributeAnnotation = this.processAttributeAnnotation(field);
        boolean foundIdAnnoation = this.processIdAnnotation(field, this.valueClass);
        if (foundAttributeAnnotation && foundIdAnnoation) {
            throw new MetaDataException(String.format("You may not specifiy an %1$s annoation and an %2$s annotation on the same field, error in field %3$s in Entry class %4$s", Id.class, Attribute.class, field.getName(), field.getDeclaringClass()));
        }
        if (this.isObjectClass() && (!this.isList() || this.valueClass != String.class)) {
            throw new MetaDataException(String.format("The type of the objectclass attribute must be List<String> in classs %1$s", field.getDeclaringClass()));
        }
    }

    public String getSyntax() {
        return this.syntax;
    }

    public boolean isBinary() {
        return this.isBinary;
    }

    public Field getField() {
        return this.field;
    }

    public CaseIgnoreString getName() {
        return this.name;
    }

    public boolean isList() {
        return this.isList;
    }

    public boolean isId() {
        return this.isId;
    }

    public boolean isObjectClass() {
        return this.isObjectClass;
    }

    public Class<?> getValueClass() {
        return this.valueClass;
    }

    public String toString() {
        return String.format("name=%1$s | field=%2$s | valueClass=%3$s | syntax=%4$s| isBinary=%5$s | isId=%6$s | isList=%7$s | isObjectClass=%8$s", this.getName(), this.getField(), this.getValueClass().getName(), this.getSyntax(), this.isBinary(), this.isId(), this.isList(), this.isObjectClass());
    }
}

