/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.Binding;
import javax.naming.ContextNotEmptyException;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.apache.commons.io.IOUtils;
import org.apache.directory.server.configuration.MutableServerStartupConfiguration;
import org.apache.directory.server.core.configuration.ShutdownConfiguration;
import org.apache.directory.server.core.partition.impl.btree.MutableBTreePartitionConfiguration;
import org.apache.directory.server.jndi.ServerContextFactory;
import org.apache.directory.server.protocol.shared.store.LdifFileLoader;
import org.springframework.core.io.Resource;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DistinguishedName;

public class LdapTestUtils {
    public static final String DEFAULT_PRINCIPAL = "uid=admin,ou=system";
    public static final String DEFAULT_PASSWORD = "secret";

    private LdapTestUtils() {
    }

    public static DirContext startApacheDirectoryServer(int port, String defaultPartitionSuffix, String defaultPartitionName, String principal, String credentials, Set extraSchemas) throws NamingException {
        MutableServerStartupConfiguration cfg = new MutableServerStartupConfiguration();
        String tempDir = System.getProperty("java.io.tmpdir");
        cfg.setWorkingDirectory(new File(tempDir));
        cfg.setLdapPort(port);
        if (extraSchemas != null) {
            Set schemas = cfg.getBootstrapSchemas();
            schemas.addAll(extraSchemas);
            cfg.setBootstrapSchemas(schemas);
        }
        MutableBTreePartitionConfiguration partitionConfiguration = new MutableBTreePartitionConfiguration();
        partitionConfiguration.setSuffix(defaultPartitionSuffix);
        partitionConfiguration.setContextEntry(LdapTestUtils.getRootPartitionAttributes(defaultPartitionName));
        partitionConfiguration.setName(defaultPartitionName);
        cfg.setContextPartitionConfigurations(Collections.singleton(partitionConfiguration));
        Hashtable env = LdapTestUtils.createEnv(principal, credentials);
        env.putAll(cfg.toJndiEnvironment());
        return new InitialDirContext(env);
    }

    public static DirContext startApacheDirectoryServer(int port, String defaultPartitionSuffix, String defaultPartitionName, String principal, String credentials) throws NamingException {
        return LdapTestUtils.startApacheDirectoryServer(port, defaultPartitionSuffix, defaultPartitionName, principal, credentials, null);
    }

    public static void destroyApacheDirectoryServer(String principal, String credentials) throws Exception {
        Properties env = new Properties();
        env.setProperty("java.naming.factory.initial", ServerContextFactory.class.getName());
        env.setProperty("java.naming.security.authentication", "simple");
        env.setProperty("java.naming.security.principal", principal);
        env.setProperty("java.naming.security.credentials", credentials);
        ShutdownConfiguration configuration = new ShutdownConfiguration();
        env.putAll((Map<?, ?>)configuration.toJndiEnvironment());
        new InitialContext(env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearSubContexts(ContextSource contextSource, Name name) throws NamingException {
        DirContext ctx = null;
        try {
            ctx = contextSource.getReadWriteContext();
            LdapTestUtils.clearSubContexts(ctx, name);
        }
        finally {
            try {
                ctx.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearSubContexts(DirContext ctx, Name name) throws NamingException {
        NamingEnumeration<Binding> enumeration = null;
        try {
            enumeration = ctx.listBindings(name);
            while (enumeration.hasMore()) {
                Binding element = enumeration.next();
                DistinguishedName childName = new DistinguishedName(element.getName());
                childName.prepend((DistinguishedName)name);
                try {
                    ctx.destroySubcontext(childName);
                }
                catch (ContextNotEmptyException e) {
                    LdapTestUtils.clearSubContexts(ctx, (Name)childName);
                    ctx.destroySubcontext(childName);
                }
            }
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        finally {
            try {
                enumeration.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLdif(ContextSource contextSource, Resource ldifFile) throws IOException {
        DirContext context = contextSource.getReadWriteContext();
        try {
            LdapTestUtils.loadLdif(context, ldifFile);
        }
        finally {
            try {
                context.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void cleanAndSetup(ContextSource contextSource, DistinguishedName rootNode, Resource ldifFile) throws NamingException, IOException {
        LdapTestUtils.clearSubContexts(contextSource, (Name)rootNode);
        LdapTestUtils.loadLdif(contextSource, ldifFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadLdif(DirContext context, Resource ldifFile) throws IOException {
        File tempFile = File.createTempFile("spring_ldap_test", ".ldif");
        try {
            InputStream inputStream = ldifFile.getInputStream();
            IOUtils.copy((InputStream)inputStream, (OutputStream)new FileOutputStream(tempFile));
            LdifFileLoader fileLoader = new LdifFileLoader(context, tempFile.getAbsolutePath());
            fileLoader.execute();
        }
        finally {
            try {
                tempFile.delete();
            }
            catch (Exception exception) {}
        }
    }

    private static Hashtable createEnv(String principal, String credentials) {
        Properties env = new Properties();
        ((Hashtable)env).put("java.naming.provider.url", "");
        ((Hashtable)env).put("java.naming.factory.initial", "org.apache.directory.server.jndi.ServerContextFactory");
        ((Hashtable)env).put("java.naming.security.principal", principal);
        ((Hashtable)env).put("java.naming.security.credentials", credentials);
        ((Hashtable)env).put("java.naming.security.authentication", "simple");
        return env;
    }

    private static Attributes getRootPartitionAttributes(String defaultPartitionName) {
        BasicAttributes attributes = new BasicAttributes();
        BasicAttribute objectClassAttribute = new BasicAttribute("objectClass");
        objectClassAttribute.add("top");
        objectClassAttribute.add("domain");
        objectClassAttribute.add("extensibleObject");
        attributes.put(objectClassAttribute);
        attributes.put("dc", defaultPartitionName);
        return attributes;
    }
}

