/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.transaction.compensating.manager;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.naming.directory.DirContext;
import org.springframework.ldap.NamingException;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextProxy;
import org.springframework.ldap.support.LdapUtils;
import org.springframework.ldap.transaction.compensating.manager.DirContextHolder;
import org.springframework.ldap.transaction.compensating.manager.TransactionAwareDirContextInvocationHandler;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class TransactionAwareContextSourceProxy
implements ContextSource {
    private ContextSource target;

    public TransactionAwareContextSourceProxy(ContextSource target) {
        this.target = target;
    }

    public ContextSource getTarget() {
        return this.target;
    }

    public DirContext getReadOnlyContext() throws NamingException {
        return this.getReadWriteContext();
    }

    private DirContext getTransactionAwareDirContextProxy(DirContext context, ContextSource target) {
        return (DirContext)Proxy.newProxyInstance(DirContextProxy.class.getClassLoader(), new Class[]{LdapUtils.getActualTargetClass(context), DirContextProxy.class}, (InvocationHandler)new TransactionAwareDirContextInvocationHandler(context, target));
    }

    public DirContext getReadWriteContext() throws NamingException {
        DirContextHolder contextHolder = (DirContextHolder)((Object)TransactionSynchronizationManager.getResource((Object)this.target));
        DirContext ctx = null;
        if (contextHolder != null) {
            ctx = contextHolder.getCtx();
        }
        if (ctx == null) {
            ctx = this.target.getReadWriteContext();
            if (contextHolder != null) {
                contextHolder.setCtx(ctx);
            }
        }
        return this.getTransactionAwareDirContextProxy(ctx, this.target);
    }

    public DirContext getContext(String principal, String credentials) throws NamingException {
        throw new UnsupportedOperationException("Not supported on a transacted ContextSource");
    }
}

