/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.boot;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.metrics.instrument.MeterRegistry;
import org.springframework.metrics.instrument.TagFormatter;
import org.springframework.metrics.instrument.web.MetricsHandlerInterceptor;
import org.springframework.metrics.instrument.web.WebmvcTagConfigurer;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
class InstrumentServletRequestConfiguration
extends WebMvcConfigurerAdapter {
    @Autowired
    MeterRegistry registry;
    @Autowired
    TagFormatter formatter;
    @Autowired(required=false)
    WebmvcTagConfigurer tagConfigurer;
    @Autowired
    Environment environment;

    InstrumentServletRequestConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean(value={WebmvcTagConfigurer.class})
    WebmvcTagConfigurer webmvcTagConfigurer(TagFormatter tagFormatter) {
        if (this.tagConfigurer != null) {
            return this.tagConfigurer;
        }
        this.tagConfigurer = new WebmvcTagConfigurer(tagFormatter);
        return this.tagConfigurer;
    }

    @Bean
    MetricsHandlerInterceptor webMetricsInterceptor() {
        return new MetricsHandlerInterceptor(this.registry, this.webmvcTagConfigurer(this.formatter), this.environment.getProperty("spring.metrics.web.server_requests.name", "http_server_requests"));
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.webMetricsInterceptor());
    }
}

