/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.boot;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.metrics.instrument.MeterRegistry;
import org.springframework.metrics.instrument.TagFormatter;
import org.springframework.metrics.instrument.web.MetricsWebFilter;
import org.springframework.metrics.instrument.web.WebfluxTagConfigurer;

@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@Configuration
public class InstrumentWebfluxRequestConfiguration {
    @Autowired(required=false)
    WebfluxTagConfigurer tagConfigurer;

    @Bean
    @ConditionalOnMissingBean(value={WebfluxTagConfigurer.class})
    WebfluxTagConfigurer webfluxTagConfigurer(TagFormatter tagFormatter) {
        if (this.tagConfigurer != null) {
            return this.tagConfigurer;
        }
        this.tagConfigurer = new WebfluxTagConfigurer(tagFormatter);
        return this.tagConfigurer;
    }

    @Bean
    public MetricsWebFilter webfluxMetrics(MeterRegistry registry, TagFormatter tagFormatter, Environment environment) {
        return new MetricsWebFilter(registry, this.webfluxTagConfigurer(tagFormatter), environment.getProperty("spring.metrics.web.server_requests.name", "http_server_requests"));
    }
}

