/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.binder;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import java.util.Arrays;
import java.util.Collections;
import org.springframework.metrics.instrument.Measurement;
import org.springframework.metrics.instrument.Meter;
import org.springframework.metrics.instrument.MeterRegistry;
import org.springframework.metrics.instrument.Meters;
import org.springframework.metrics.instrument.Tag;
import org.springframework.metrics.instrument.binder.MeterBinder;

public class CacheMetrics
implements MeterBinder {
    private final String name;
    private final Iterable<Tag> tags;
    private final Cache<?, ?> cache;

    public CacheMetrics(String name, Iterable<Tag> tags, Cache<?, ?> cache) {
        this.name = name;
        this.tags = tags;
        this.cache = cache;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        registry.gauge(this.name + "_size", this.tags, this.cache, Cache::size);
        registry.register(Meters.build(this.name + "_requests").type(Meter.Type.Counter).create(this.cache, (n, cacheRef) -> {
            CacheStats stats = cacheRef.stats();
            return Arrays.asList(new Measurement((String)n, Collections.singletonList(Tag.of("result", "hit")), stats.hitCount()), new Measurement((String)n, Collections.singletonList(Tag.of("result", "miss")), stats.missCount()));
        }));
        registry.gauge(this.name + "_evictions", this.tags, this.cache, c -> c.stats().evictionCount());
        registry.gauge(this.name + "_load_duration", this.tags, this.cache, c -> c.stats().totalLoadTime());
        if (this.cache instanceof LoadingCache) {
            registry.gauge(this.name + "_loads", this.tags, this.cache, c -> c.stats().loadCount());
            registry.gauge(this.name + "_load_failures", this.tags, this.cache, c -> c.stats().loadExceptionCount());
        }
    }
}

