/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.prometheus;

import io.prometheus.client.Counter;
import java.util.Collections;
import org.springframework.metrics.instrument.Counter;
import org.springframework.metrics.instrument.Measurement;
import org.springframework.metrics.instrument.Meter;
import org.springframework.metrics.instrument.Tag;
import org.springframework.metrics.instrument.internal.MeterId;

public class PrometheusCounter
implements Counter {
    private final MeterId id;
    private Counter.Child counter;

    PrometheusCounter(MeterId id, Counter.Child counter) {
        this.id = id;
        this.counter = counter;
    }

    @Override
    public void increment() {
        this.counter.inc();
    }

    @Override
    public void increment(double amount) {
        this.counter.inc(amount);
    }

    @Override
    public double count() {
        return this.counter.get();
    }

    @Override
    public String getName() {
        return this.id.getName();
    }

    @Override
    public Iterable<Tag> getTags() {
        return this.id.getTags();
    }

    @Override
    public Meter.Type getType() {
        return Meter.Type.Counter;
    }

    @Override
    public Iterable<Measurement> measure() {
        return Collections.singletonList(this.id.measurement(this.count()));
    }
}

