/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.prometheus;

import java.util.concurrent.TimeUnit;
import org.springframework.metrics.instrument.Clock;
import org.springframework.metrics.instrument.Measurement;
import org.springframework.metrics.instrument.internal.AbstractTimer;
import org.springframework.metrics.instrument.internal.MeterId;
import org.springframework.metrics.instrument.internal.TimeUtils;
import org.springframework.metrics.instrument.prometheus.CustomPrometheusSummary;

public class PrometheusTimer
extends AbstractTimer {
    private CustomPrometheusSummary.Child summary;

    PrometheusTimer(MeterId id, CustomPrometheusSummary.Child summary, Clock clock) {
        super(id, clock);
        this.summary = summary;
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        if (amount >= 0L) {
            double seconds = (double)TimeUnit.NANOSECONDS.convert(amount, unit) / 1.0E9;
            this.summary.observe(seconds);
        }
    }

    @Override
    public long count() {
        return this.summary.count();
    }

    @Override
    public double totalTime(TimeUnit unit) {
        return TimeUtils.secondsToUnit(this.summary.sum(), unit);
    }

    @Override
    public Iterable<Measurement> measure() {
        return this.summary.measure();
    }
}

