/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.simple;

import com.netflix.spectator.impl.AtomicDouble;
import java.util.Collections;
import org.springframework.metrics.instrument.Counter;
import org.springframework.metrics.instrument.Measurement;
import org.springframework.metrics.instrument.Meter;
import org.springframework.metrics.instrument.Tag;
import org.springframework.metrics.instrument.internal.MeterId;
import org.springframework.metrics.instrument.simple.SimpleUtils;

public class SimpleCounter
implements Counter {
    private final MeterId id;
    private AtomicDouble count = new AtomicDouble(0.0);

    SimpleCounter(MeterId id) {
        this.id = id;
    }

    @Override
    public void increment() {
        this.count.addAndGet(1.0);
    }

    @Override
    public void increment(double amount) {
        this.count.addAndGet(amount);
    }

    @Override
    public double count() {
        return this.count.get();
    }

    @Override
    public String getName() {
        return this.id.getName();
    }

    @Override
    public Iterable<Tag> getTags() {
        return this.id.getTags();
    }

    @Override
    public Meter.Type getType() {
        return Meter.Type.Counter;
    }

    @Override
    public Iterable<Measurement> measure() {
        return Collections.singletonList(this.id.withTags(SimpleUtils.typeTag(this.getType())).measurement(this.count()));
    }
}

