/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.ToDoubleFunction;
import org.springframework.metrics.instrument.Clock;
import org.springframework.metrics.instrument.Counter;
import org.springframework.metrics.instrument.DistributionSummary;
import org.springframework.metrics.instrument.LongTaskTimer;
import org.springframework.metrics.instrument.Meter;
import org.springframework.metrics.instrument.MeterRegistry;
import org.springframework.metrics.instrument.Tag;
import org.springframework.metrics.instrument.Timer;
import org.springframework.metrics.instrument.internal.AbstractMeterRegistry;
import org.springframework.metrics.instrument.internal.MapAccess;
import org.springframework.metrics.instrument.internal.MeterId;
import org.springframework.metrics.instrument.simple.SimpleCounter;
import org.springframework.metrics.instrument.simple.SimpleDistributionSummary;
import org.springframework.metrics.instrument.simple.SimpleGauge;
import org.springframework.metrics.instrument.simple.SimpleLongTaskTimer;
import org.springframework.metrics.instrument.simple.SimpleTimer;
import org.springframework.metrics.instrument.stats.hist.Histogram;
import org.springframework.metrics.instrument.stats.quantile.Quantiles;

public class SimpleMeterRegistry
extends AbstractMeterRegistry {
    private final ConcurrentMap<MeterId, Meter> meterMap = new ConcurrentHashMap<MeterId, Meter>();

    public SimpleMeterRegistry() {
        this(Clock.SYSTEM);
    }

    public SimpleMeterRegistry(Clock clock) {
        super(clock);
    }

    @Override
    public Counter counter(String name, Iterable<Tag> tags) {
        return MapAccess.computeIfAbsent(this.meterMap, new MeterId(name, tags), SimpleCounter::new);
    }

    @Override
    public DistributionSummary distributionSummary(String name, Iterable<Tag> tags, Quantiles quantiles, Histogram<?> histogram) {
        this.registerQuantilesGaugeIfNecessary(name, tags, quantiles);
        return MapAccess.computeIfAbsent(this.meterMap, new MeterId(name, tags), SimpleDistributionSummary::new);
    }

    @Override
    protected Timer timer(String name, Iterable<Tag> tags, Quantiles quantiles, Histogram<?> histogram) {
        this.registerQuantilesGaugeIfNecessary(name, tags, quantiles);
        return MapAccess.computeIfAbsent(this.meterMap, new MeterId(name, tags), id -> new SimpleTimer((MeterId)id, this.getClock()));
    }

    private void registerQuantilesGaugeIfNecessary(String name, Iterable<Tag> tags, Quantiles quantiles) {
        if (quantiles != null) {
            for (Double q : quantiles.monitored()) {
                LinkedList<Tag> quantileTags = new LinkedList<Tag>();
                tags.forEach(quantileTags::add);
                quantileTags.add(Tag.of("quantile", Double.isNaN(q) ? "NaN" : Double.toString(q)));
                MapAccess.computeIfAbsent(this.meterMap, new MeterId(name + ".quantiles", quantileTags), id -> new SimpleGauge<Double>((MeterId)id, q, quantiles::get));
            }
        }
    }

    @Override
    public LongTaskTimer longTaskTimer(String name, Iterable<Tag> tags) {
        return MapAccess.computeIfAbsent(this.meterMap, new MeterId(name, tags), id -> new SimpleLongTaskTimer((MeterId)id, this.getClock()));
    }

    @Override
    public MeterRegistry register(Meter meter) {
        this.meterMap.put(new MeterId(meter.getName(), meter.getTags()), meter);
        return this;
    }

    @Override
    public <T> T gauge(String name, Iterable<Tag> tags, T obj, ToDoubleFunction<T> f) {
        MapAccess.computeIfAbsent(this.meterMap, new MeterId(name, tags), id -> new SimpleGauge<Object>((MeterId)id, obj, f));
        return obj;
    }

    @Override
    public Collection<Meter> getMeters() {
        return this.meterMap.values();
    }

    @Override
    public <M extends Meter> Optional<M> findMeter(Class<M> mClass, String name, Iterable<Tag> tags) {
        ArrayList tagsToMatch = new ArrayList();
        tags.forEach(tagsToMatch::add);
        return this.meterMap.keySet().stream().filter(id -> id.getName().equals(name)).filter(id -> id.getTags().containsAll(tagsToMatch)).findAny().map(this.meterMap::get).map(m -> m);
    }

    public void clear() {
        this.meterMap.clear();
    }
}

