/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.simple;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.springframework.metrics.instrument.Clock;
import org.springframework.metrics.instrument.Measurement;
import org.springframework.metrics.instrument.Tag;
import org.springframework.metrics.instrument.internal.AbstractTimer;
import org.springframework.metrics.instrument.internal.MeterId;
import org.springframework.metrics.instrument.internal.TimeUtils;
import org.springframework.metrics.instrument.simple.SimpleUtils;

public class SimpleTimer
extends AbstractTimer {
    private LongAdder count = new LongAdder();
    private LongAdder totalTime = new LongAdder();

    SimpleTimer(MeterId id, Clock clock) {
        super(id, clock);
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        this.count.increment();
        this.totalTime.add(TimeUnit.NANOSECONDS.convert(amount, unit));
    }

    @Override
    public long count() {
        return this.count.longValue();
    }

    @Override
    public double totalTime(TimeUnit unit) {
        return TimeUtils.nanosToUnit(this.totalTime.doubleValue(), unit);
    }

    @Override
    public Iterable<Measurement> measure() {
        return Arrays.asList(this.id.withTags(SimpleUtils.typeTag(this.getType()), Tag.of("statistic", "count")).measurement(this.count()), this.id.withTags(SimpleUtils.typeTag(this.getType()), Tag.of("statistic", "amount")).measurement(this.totalTime(TimeUnit.NANOSECONDS)));
    }
}

