/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.spectator;

import com.netflix.spectator.api.AbstractMeter;
import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.DefaultRegistry;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Registry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.metrics.instrument.Clock;
import org.springframework.metrics.instrument.Counter;
import org.springframework.metrics.instrument.DistributionSummary;
import org.springframework.metrics.instrument.LongTaskTimer;
import org.springframework.metrics.instrument.Meter;
import org.springframework.metrics.instrument.MeterRegistry;
import org.springframework.metrics.instrument.Tag;
import org.springframework.metrics.instrument.Timer;
import org.springframework.metrics.instrument.internal.AbstractMeterRegistry;
import org.springframework.metrics.instrument.internal.ImmutableTag;
import org.springframework.metrics.instrument.spectator.CustomSpectatorToDoubleGauge;
import org.springframework.metrics.instrument.spectator.ExternalClockSpectatorRegistry;
import org.springframework.metrics.instrument.spectator.SpectatorCounter;
import org.springframework.metrics.instrument.spectator.SpectatorDistributionSummary;
import org.springframework.metrics.instrument.spectator.SpectatorGauge;
import org.springframework.metrics.instrument.spectator.SpectatorLongTaskTimer;
import org.springframework.metrics.instrument.spectator.SpectatorTimer;
import org.springframework.metrics.instrument.spectator.SpectatorUtils;
import org.springframework.metrics.instrument.stats.hist.Histogram;
import org.springframework.metrics.instrument.stats.quantile.Quantiles;

public class SpectatorMeterRegistry
extends AbstractMeterRegistry {
    private final Registry registry;
    private final Map<com.netflix.spectator.api.Meter, Meter> meterMap = new HashMap<com.netflix.spectator.api.Meter, Meter>();
    private final com.netflix.spectator.api.Clock spectatorClock = new com.netflix.spectator.api.Clock(){

        public long wallTime() {
            return com.netflix.spectator.api.Clock.SYSTEM.wallTime();
        }

        public long monotonicTime() {
            return SpectatorMeterRegistry.this.getClock().monotonicTime();
        }
    };

    public SpectatorMeterRegistry() {
        this((Registry)new DefaultRegistry());
    }

    public SpectatorMeterRegistry(Registry registry) {
        this(registry, Clock.SYSTEM);
    }

    @Autowired
    public SpectatorMeterRegistry(Registry registry, final Clock clock) {
        super(clock);
        this.registry = new ExternalClockSpectatorRegistry(registry, new com.netflix.spectator.api.Clock(){

            public long wallTime() {
                return System.currentTimeMillis();
            }

            public long monotonicTime() {
                return clock.monotonicTime();
            }
        });
    }

    private Collection<com.netflix.spectator.api.Tag> toSpectatorTags(Iterable<Tag> tags) {
        return StreamSupport.stream(tags.spliterator(), false).map(t -> new BasicTag(t.getKey(), t.getValue())).collect(Collectors.toList());
    }

    @Override
    public Collection<Meter> getMeters() {
        return this.meterMap.values();
    }

    @Override
    public <M extends Meter> Optional<M> findMeter(Class<M> mClass, String name, Iterable<Tag> tags) {
        ArrayList tagsToMatch = new ArrayList();
        tags.forEach(tagsToMatch::add);
        return this.meterMap.entrySet().stream().filter(e -> mClass.isInstance(e.getValue())).filter(e -> ((com.netflix.spectator.api.Meter)e.getKey()).id().name().equals(name)).filter(e -> StreamSupport.stream(((com.netflix.spectator.api.Meter)e.getKey()).id().tags().spliterator(), false).map(t -> new ImmutableTag(t.key(), t.value())).collect(Collectors.toList()).containsAll(tagsToMatch)).map(e -> (Meter)e.getValue()).findAny();
    }

    @Override
    public Counter counter(String name, Iterable<Tag> tags) {
        com.netflix.spectator.api.Counter counter = this.registry.counter(name, this.toSpectatorTags(tags));
        return (Counter)this.meterMap.computeIfAbsent((com.netflix.spectator.api.Meter)counter, c -> new SpectatorCounter(counter));
    }

    @Override
    public DistributionSummary distributionSummary(String name, Iterable<Tag> tags, Quantiles quantiles, Histogram<?> histogram) {
        this.registerQuantilesGaugeIfNecessary(name, tags, quantiles);
        com.netflix.spectator.api.DistributionSummary ds = this.registry.distributionSummary(name, this.toSpectatorTags(tags));
        return (DistributionSummary)this.meterMap.computeIfAbsent((com.netflix.spectator.api.Meter)ds, d -> new SpectatorDistributionSummary(ds));
    }

    @Override
    protected Timer timer(String name, Iterable<Tag> tags, Quantiles quantiles, Histogram<?> histogram) {
        this.registerQuantilesGaugeIfNecessary(name, tags, quantiles);
        this.registerHistogramCounterIfNecessary(name, tags, histogram);
        com.netflix.spectator.api.Timer timer = this.registry.timer(name, this.toSpectatorTags(tags));
        return (Timer)this.meterMap.computeIfAbsent((com.netflix.spectator.api.Meter)timer, t -> new SpectatorTimer(timer, this.getClock()));
    }

    private void registerHistogramCounterIfNecessary(String name, Iterable<Tag> tags, Histogram<?> histogram) {
    }

    private void registerQuantilesGaugeIfNecessary(String name, Iterable<Tag> tags, Quantiles quantiles) {
        if (quantiles != null) {
            for (Double q : quantiles.monitored()) {
                LinkedList<com.netflix.spectator.api.Tag> quantileTags = new LinkedList<com.netflix.spectator.api.Tag>(this.toSpectatorTags(tags));
                quantileTags.add((com.netflix.spectator.api.Tag)new BasicTag("quantile", Double.isNaN(q) ? "NaN" : Double.toString(q)));
                quantileTags.add((com.netflix.spectator.api.Tag)new BasicTag("statistic", "quantile"));
                this.registry.gauge(this.registry.createId(name, quantileTags), (Object)q, quantiles::get);
            }
        }
    }

    @Override
    public LongTaskTimer longTaskTimer(String name, Iterable<Tag> tags) {
        com.netflix.spectator.api.LongTaskTimer timer = this.registry.longTaskTimer(name, this.toSpectatorTags(tags));
        return (LongTaskTimer)this.meterMap.computeIfAbsent((com.netflix.spectator.api.Meter)timer, t -> new SpectatorLongTaskTimer(timer));
    }

    @Override
    public MeterRegistry register(Meter meter) {
        AbstractMeter<Meter> spectatorMeter = new AbstractMeter<Meter>(this.spectatorClock, SpectatorUtils.spectatorId(this.registry, meter.getName(), meter.getTags()), meter){

            public Iterable<Measurement> measure() {
                return StreamSupport.stream(((Meter)this.ref.get()).measure().spliterator(), false).map(m -> new Measurement(SpectatorUtils.spectatorId(SpectatorMeterRegistry.this.registry, m.getName(), m.getTags()), this.clock.wallTime(), m.getValue())).collect(Collectors.toList());
            }
        };
        this.meterMap.put((com.netflix.spectator.api.Meter)spectatorMeter, meter);
        return this;
    }

    @Override
    public <T> T gauge(String name, Iterable<Tag> tags, T obj, ToDoubleFunction<T> f) {
        Id gaugeId = this.registry.createId(name, this.toSpectatorTags(tags));
        CustomSpectatorToDoubleGauge gauge = new CustomSpectatorToDoubleGauge(this.registry.clock(), gaugeId, obj, f);
        this.registry.register(gauge);
        this.meterMap.computeIfAbsent((com.netflix.spectator.api.Meter)gauge, g -> new SpectatorGauge(gauge));
        return obj;
    }

    public Registry getSpectatorRegistry() {
        return this.registry;
    }
}

