/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.stats.hist;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import org.springframework.metrics.instrument.stats.hist.Bucket;
import org.springframework.metrics.instrument.stats.hist.CumulativeBucketFunction;
import org.springframework.metrics.instrument.stats.hist.FixedCumulativeBucketFunction;
import org.springframework.metrics.instrument.stats.hist.Histogram;
import org.springframework.metrics.instrument.stats.hist.TimeScaleCumulativeHistogram;

public class CumulativeHistogram<T>
implements Histogram<T> {
    protected final CumulativeBucketFunction<T> f;
    private final ConcurrentNavigableMap<T, Bucket<T>> buckets;

    public CumulativeHistogram(CumulativeBucketFunction<T> f) {
        this.f = f;
        this.buckets = f.bucketComparator() == null ? new ConcurrentSkipListMap<T, Bucket<T>>() : new ConcurrentSkipListMap(f.bucketComparator());
        f.buckets().forEach(b -> this.buckets.put(b, new Bucket<Object>(b)));
    }

    @Override
    public void observe(double value) {
        this.buckets.tailMap((Object)this.f.bucketFloor(value), true).keySet().forEach(k -> ((Bucket)this.buckets.get(k)).increment());
    }

    @Override
    public Collection<Bucket<T>> getBuckets() {
        return this.buckets.values();
    }

    public static <T> CumulativeHistogram<T> buckets(CumulativeBucketFunction<T> bucketFunction) {
        return new CumulativeHistogram<T>(bucketFunction);
    }

    public static TimeScaleCumulativeHistogram buckets(CumulativeBucketFunction<Double> bucketFunction, TimeUnit timeScale) {
        return new TimeScaleCumulativeHistogram(bucketFunction, timeScale);
    }

    public static CumulativeBucketFunction<Double> exponential(double start, double exp, int count) {
        return CumulativeHistogram.fromDoubleStream(IntStream.rangeClosed(0, count - 1).mapToDouble(n -> start * Math.pow(exp, n)));
    }

    public static CumulativeBucketFunction<Double> linear(double start, double width, int count) {
        return CumulativeHistogram.fromDoubleStream(IntStream.rangeClosed(0, count - 1).mapToDouble(n -> start + width * (double)n));
    }

    private static FixedCumulativeBucketFunction<Double> fromDoubleStream(DoubleStream stream) {
        Set buckets = stream.collect(HashSet::new, Set::add, Set::addAll);
        buckets.add(Double.POSITIVE_INFINITY);
        return new FixedCumulativeBucketFunction<Double>(d -> d, buckets, null);
    }
}

