/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.stats.quantile;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.springframework.metrics.instrument.stats.quantile.Quantiles;

public class GKQuantiles
implements Quantiles {
    private Collection<Double> monitored;
    private List<Tuple> summary;
    private double minimum;
    private double maximum;
    private int stepsUntilMerge;
    private boolean initialPhase;
    private Integer count;
    private double epsilon;

    public GKQuantiles(Collection<Double> monitored, double epsilon) {
        this.monitored = monitored;
        if (epsilon <= 0.0 || epsilon >= 1.0) {
            throw new RuntimeException("An appropriate epsilon value must lay between 0 and 1.");
        }
        this.setEpsilon(epsilon);
    }

    @Override
    public Collection<Double> monitored() {
        return this.monitored;
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
        this.minimum = Double.MAX_VALUE;
        this.maximum = Double.MIN_VALUE;
        Double mergingSteps = Math.floor(1.0 / (2.0 * epsilon));
        this.stepsUntilMerge = mergingSteps.intValue();
        this.summary = new CopyOnWriteArrayList<Tuple>();
        this.count = 0;
        this.initialPhase = true;
    }

    @Override
    public void observe(double value) {
        this.insertItem(value);
        this.incrementCount();
        if (this.count % this.stepsUntilMerge == 0 && !this.initialPhase) {
            this.compress();
        }
    }

    @Override
    public Double get(double q) {
        Object[] copyOfSummary;
        if (this.count == 0 || q < 0.0 || q > 1.0) {
            return Double.NaN;
        }
        if (this.count == 1) {
            return this.minimum;
        }
        if (this.count == 2) {
            if (q < 0.5) {
                return this.minimum;
            }
            if (q >= 0.5) {
                return this.maximum;
            }
        }
        int wantedRank = (int)(q * (double)this.count.floatValue());
        int currentMinRank = 0;
        Double tolerance = this.epsilon * this.count.doubleValue();
        if ((double)wantedRank > (double)this.count.intValue() - tolerance) {
            return this.maximum;
        }
        if ((double)wantedRank < tolerance) {
            return this.minimum;
        }
        Tuple lastTuple = this.summary.get(0);
        for (Object aCopyOfSummary : copyOfSummary = this.summary.toArray()) {
            Tuple currentTuple = (Tuple)aCopyOfSummary;
            int currentMaxRank = (currentMinRank += currentTuple.getOffset().intValue()) + currentTuple.getRange();
            if (!((double)(currentMaxRank - wantedRank) <= tolerance)) continue;
            lastTuple = currentTuple;
            if (!((double)(wantedRank - currentMinRank) <= tolerance)) continue;
            return currentTuple.getValue();
        }
        return lastTuple.getValue();
    }

    private void insertItem(Double item) {
        if (item < this.minimum) {
            this.insertAsNewMinimum(item);
            return;
        }
        if (item >= this.maximum) {
            this.insertAsNewMaximum(item);
            return;
        }
        this.insertInBetween(item);
    }

    private void insertAsNewMinimum(Double item) {
        this.minimum = item;
        Tuple newTuple = new Tuple(item, 1, 0);
        this.summary.add(0, newTuple);
    }

    private void insertAsNewMaximum(Double item) {
        if (item == this.maximum) {
            Tuple newTuple = new Tuple(item, 1, this.computeRangeForNewTuple(this.summary.get(this.summary.size() - 1)));
            this.summary.add(this.summary.size() - 2, newTuple);
        } else {
            this.maximum = item;
            Tuple newTuple = new Tuple(item, 1, 0);
            this.summary.add(newTuple);
        }
    }

    private void insertInBetween(Double item) {
        Tuple newTuple = new Tuple(item, 1, 0);
        for (int i = 0; i < this.summary.size() - 1; ++i) {
            Tuple current = this.summary.get(i);
            Tuple next = this.summary.get(i + 1);
            if (!(item >= current.getValue()) || !(item < next.getValue())) continue;
            if (!this.initialPhase) {
                newTuple.setRange(this.computeRangeForNewTuple(next));
            }
            this.summary.add(i + 1, newTuple);
            return;
        }
    }

    private void incrementCount() {
        Integer n = this.count;
        Integer n2 = this.count = Integer.valueOf(this.count + 1);
        if (this.count.equals(this.stepsUntilMerge)) {
            this.initialPhase = false;
        }
    }

    private void compress() {
        List<List<Tuple>> partitions = this.getPartitionsOfSummary();
        List<Tuple> mergedSummary = new CopyOnWriteArrayList<Tuple>();
        mergedSummary.addAll((Collection)partitions.get(partitions.size() - 1));
        for (int i = partitions.size() - 2; i > 0; --i) {
            mergedSummary.addAll(this.mergeWorkingSet(partitions.get(i)));
        }
        mergedSummary.addAll((Collection)partitions.get(0));
        mergedSummary = this.sortWorkingSet(mergedSummary);
        this.summary = mergedSummary;
    }

    private List<Tuple> mergeWorkingSet(List<Tuple> workingSet) {
        if (workingSet.size() < 2) {
            return workingSet;
        }
        LinkedList<Tuple> mergedWorkingSet = new LinkedList<Tuple>();
        LinkedList<Tuple> currentWorkingSet = new LinkedList<Tuple>();
        LinkedList<Tuple> remainingWorkingSet = new LinkedList<Tuple>();
        remainingWorkingSet.addAll(workingSet);
        int index = 1;
        int bandOfChildren = this.computeBandOfTuple(workingSet.get(0));
        int bandOfParent = this.computeBandOfTuple(workingSet.get(index));
        currentWorkingSet.add(workingSet.get(0));
        remainingWorkingSet.removeFirst();
        while (bandOfChildren == bandOfParent && workingSet.size() - 1 > index) {
            currentWorkingSet.add(workingSet.get(index));
            remainingWorkingSet.remove(workingSet.get(index));
            bandOfParent = this.computeBandOfTuple(workingSet.get(++index));
        }
        Tuple parent = workingSet.get(index);
        if (bandOfParent == bandOfChildren) {
            currentWorkingSet.add(parent);
            mergedWorkingSet.addAll(this.mergeSiblings(currentWorkingSet));
            return mergedWorkingSet;
        }
        int capacityOfParent = this.computeCapacityOfTuple(parent);
        while (capacityOfParent > currentWorkingSet.getLast().getOffset() && currentWorkingSet.size() > 1) {
            this.merge(currentWorkingSet.getLast(), parent);
            currentWorkingSet.removeLast();
            capacityOfParent = this.computeCapacityOfTuple(parent);
        }
        if (currentWorkingSet.isEmpty()) {
            mergedWorkingSet.addAll(this.mergeWorkingSet(remainingWorkingSet));
        } else {
            remainingWorkingSet.remove(parent);
            mergedWorkingSet.addAll(this.mergeSiblings(currentWorkingSet));
            mergedWorkingSet.add(parent);
            mergedWorkingSet.addAll(this.mergeWorkingSet(remainingWorkingSet));
        }
        return mergedWorkingSet;
    }

    private LinkedList<Tuple> mergeSiblings(LinkedList<Tuple> workingSet) {
        if (workingSet.size() < 2) {
            return workingSet;
        }
        LinkedList<Tuple> mergedSiblings = new LinkedList<Tuple>();
        Tuple lastSibling = workingSet.getLast();
        workingSet.removeLast();
        boolean canStillMerge = true;
        while (canStillMerge && !workingSet.isEmpty()) {
            if (this.areMergeable(workingSet.getLast(), lastSibling)) {
                this.merge(workingSet.getLast(), lastSibling);
                workingSet.removeLast();
                continue;
            }
            canStillMerge = false;
        }
        mergedSiblings.add(lastSibling);
        mergedSiblings.addAll(this.mergeSiblings(workingSet));
        return mergedSiblings;
    }

    private void merge(Tuple left, Tuple right) {
        right.setOffset(right.getOffset() + left.getOffset());
    }

    private Integer computeRangeForNewTuple(Tuple successor) {
        int successorOffset;
        if (this.initialPhase) {
            return 0;
        }
        Double range = 2.0 * this.epsilon * this.count.doubleValue();
        range = Math.floor(range);
        int successorRange = successor.getRange();
        if (successorRange + (successorOffset = successor.getOffset().intValue()) - 1 >= 0) {
            return successorRange + successorOffset - 1;
        }
        return range.intValue();
    }

    private List<List<Tuple>> getPartitionsOfSummary() {
        LinkedList<List<Tuple>> partitions = new LinkedList<List<Tuple>>();
        List<Tuple> workingSet = this.summary;
        Tuple minimum = workingSet.get(0);
        Tuple maximum = workingSet.get(workingSet.size() - 1);
        workingSet.remove(0);
        if (!workingSet.isEmpty()) {
            workingSet.remove(workingSet.size() - 1);
        }
        LinkedList<Tuple> currentPartition = new LinkedList<Tuple>();
        currentPartition.add(minimum);
        partitions.add(currentPartition);
        currentPartition = new LinkedList();
        if (workingSet.size() < 2) {
            partitions.add(workingSet);
            currentPartition = new LinkedList();
            currentPartition.add(maximum);
            partitions.add(currentPartition);
            return partitions;
        }
        while (workingSet.size() >= 2) {
            Tuple lastTuple = workingSet.get(workingSet.size() - 1);
            Tuple lastButOneTuple = workingSet.get(workingSet.size() - 2);
            currentPartition.addFirst(lastTuple);
            if (this.isPartitionBorder(lastButOneTuple, lastTuple)) {
                partitions.add(currentPartition);
                currentPartition = new LinkedList();
            } else if (workingSet.size() == 2) {
                currentPartition.addFirst(lastButOneTuple);
            }
            workingSet.remove(workingSet.size() - 1);
        }
        partitions.add(currentPartition);
        currentPartition = new LinkedList();
        currentPartition.add(maximum);
        partitions.add(currentPartition);
        return partitions;
    }

    private Integer computeCapacityOfTuple(Tuple tuple) {
        Integer offset = tuple.getOffset();
        Double currentMaxCapacity = Math.floor(2.0 * this.epsilon * (double)this.count.intValue());
        return currentMaxCapacity.intValue() - offset;
    }

    private Integer computeBandOfTuple(Tuple tuple) {
        double alpha;
        Double p = Math.floor(2.0 * this.epsilon * (double)this.count.intValue());
        if (this.areLogarithmicallyEqual(p, tuple.getRange().doubleValue())) {
            return 0;
        }
        if (tuple.getRange() == 0) {
            return -1;
        }
        for (alpha = 0.0; alpha < Math.log(p) / Math.log(2.0); alpha += 1.0) {
            double upperBound;
            double lowerBound = p - Math.pow(2.0, alpha) - p % Math.pow(2.0, alpha);
            if (!(lowerBound <= (double)tuple.getRange().intValue()) || !((upperBound = p - Math.pow(2.0, alpha - 1.0) - p % Math.pow(2.0, alpha - 1.0)) >= (double)tuple.getRange().intValue())) continue;
            return (int)alpha;
        }
        return (int)alpha;
    }

    private boolean areLogarithmicallyEqual(Double valueOne, Double valueTwo) {
        return Math.floor(Math.log(valueOne)) == Math.floor(Math.log(valueTwo));
    }

    private boolean areMergeable(Tuple tuple, Tuple parent) {
        int capacityOfParent = this.computeCapacityOfTuple(parent);
        return capacityOfParent > tuple.getOffset() && this.computeBandOfTuple(parent) >= this.computeBandOfTuple(tuple);
    }

    private boolean isPartitionBorder(Tuple left, Tuple right) {
        return this.computeBandOfTuple(left) > this.computeBandOfTuple(right);
    }

    private List<Tuple> sortWorkingSet(List<Tuple> workingSet) {
        CopyOnWriteArrayList<Tuple> sortedWorkingSet = new CopyOnWriteArrayList<Tuple>();
        while (workingSet.size() > 1) {
            Tuple currentMinimum = workingSet.get(0);
            for (Tuple aWorkingSet : workingSet) {
                if (!(currentMinimum.getValue() > aWorkingSet.getValue())) continue;
                currentMinimum = aWorkingSet;
            }
            workingSet.remove(currentMinimum);
            sortedWorkingSet.add(currentMinimum);
        }
        sortedWorkingSet.add(workingSet.get(0));
        return sortedWorkingSet;
    }

    public Integer getCount() {
        return this.count;
    }

    public String toString() {
        return this.getClass().getCanonicalName() + " { epsilon=" + this.epsilon + " }";
    }

    public static Builder quantiles(double ... quantiles) {
        return new Builder().quantiles(quantiles);
    }

    public static class Builder {
        private Collection<Double> monitored = new ArrayList<Double>();
        private double error = 0.05;

        public Builder quantiles(double ... quantiles) {
            for (double quantile : quantiles) {
                this.monitored.add(quantile);
            }
            return this;
        }

        public Builder error(double epsilon) {
            this.error = epsilon;
            return this;
        }

        public GKQuantiles create() {
            return new GKQuantiles(this.monitored, this.error);
        }
    }

    private class Tuple
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Double value;
        private Integer offset;
        private Integer range;

        Tuple(Double value, Integer offset, Integer range) {
            this.value = value;
            this.offset = offset;
            this.range = range;
        }

        public Double getValue() {
            return this.value;
        }

        Integer getOffset() {
            return this.offset;
        }

        void setOffset(Integer offset) {
            this.offset = offset;
        }

        Integer getRange() {
            return this.range;
        }

        void setRange(Integer range) {
            this.range = range;
        }

        public String toString() {
            return "( " + this.value + ", " + this.offset + ", " + this.range + " )";
        }
    }
}

