/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.stats.quantile;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Objects;
import org.springframework.metrics.instrument.stats.quantile.GKQuantiles;
import org.springframework.metrics.instrument.stats.quantile.PowerOfTwo;
import org.springframework.metrics.instrument.stats.quantile.SlidingWindow;

public class WindowSketchQuantiles
implements org.springframework.metrics.instrument.stats.quantile.Quantiles {
    private Collection<Double> monitored;
    private static final long serialVersionUID = 8629450116663341157L;
    private Long elementCount;
    private int windowSize;
    private int maxLevel;
    private GKQuantiles initialGK;
    private LinkedList<Block> levels = new LinkedList();
    private LinkedList<SlidingWindow<Quantiles>> quantiles;
    private double epsilon;

    public WindowSketchQuantiles(Collection<Double> monitored, double epsilon) {
        this.monitored = monitored;
        if (epsilon <= 0.0 || epsilon >= 1.0) {
            throw new RuntimeException("An appropriate epsilon value must lay between 0 and 1.");
        }
        this.initialGK = new GKQuantiles(monitored, epsilon);
        this.quantiles = new LinkedList();
        this.elementCount = 0L;
        this.setWindowSize(32768);
        Double value = 1.0 / epsilon;
        this.epsilon = 1.0 / PowerOfTwo.floorToNext(value);
        this.prepareLevels();
    }

    @Override
    public void observe(double value) {
        this.incrementCount();
        this.insertElement(value);
        if (this.elementCount < (long)this.windowSize) {
            this.initialGK.observe(value);
        }
        this.slideWindow();
    }

    @Override
    public Double get(double q) {
        if (this.elementCount < (long)this.windowSize) {
            return this.initialGK.get(q);
        }
        LinkedList<Double> summary = this.getFinalSummary();
        Double rank = q * (double)summary.size();
        return summary.get(rank.intValue());
    }

    @Override
    public Collection<Double> monitored() {
        return this.monitored;
    }

    private void prepareLevels() {
        this.computeMaximumLevel();
        Double blockSize = this.computeMinBlockSize();
        Float levelEpsilon = this.computeEpsilonForMinLevel();
        for (int i = 0; i < this.maxLevel + 1; ++i) {
            Block newBlock = new Block(levelEpsilon, blockSize.intValue());
            this.levels.addLast(newBlock);
            blockSize = blockSize * 2.0;
            levelEpsilon = Float.valueOf(levelEpsilon.floatValue() / 2.0f);
            SlidingWindow newWindow = new SlidingWindow(this.windowSize);
            this.quantiles.add(newWindow);
        }
    }

    private void computeMaximumLevel() {
        Double maxLevel = Math.log10(4.0 / this.epsilon) / Math.log10(2.0);
        this.maxLevel = maxLevel.intValue();
    }

    private Float computeEpsilonForMinLevel() {
        int divisor = 2 * (2 * this.maxLevel + 2);
        Double epsilon = this.epsilon * Math.pow(2.0, this.maxLevel) / (double)divisor;
        return Float.valueOf(epsilon.floatValue());
    }

    private Double computeMinBlockSize() {
        Double minBlockSize = this.epsilon * (double)this.windowSize;
        return minBlockSize / 4.0;
    }

    public final void setWindowSize(int windowSize) {
        if ((windowSize = PowerOfTwo.ceilToNext(windowSize)) <= 128) {
            return;
        }
        this.quantiles = new LinkedList();
        this.elementCount = 0L;
        this.windowSize = windowSize;
        this.prepareLevels();
    }

    private void insertElement(Double item) {
        for (int i = 0; i < this.maxLevel + 1; ++i) {
            this.levels.get(i).insert(item);
            if (this.elementCount % (long)this.levels.get(i).getBlockSize().intValue() != 0L) continue;
            Quantiles newQuantiles = new Quantiles(this.levels.get(i).getEpsilon(), this.levels.get(i).getSummary());
            this.quantiles.get(i).add(newQuantiles, this.levels.get(i).getBlockSize());
        }
    }

    private void incrementCount() {
        WindowSketchQuantiles windowSketchQuantiles = this;
        Long l = windowSketchQuantiles.elementCount;
        Long l2 = windowSketchQuantiles.elementCount = Long.valueOf(windowSketchQuantiles.elementCount + 1L);
    }

    private LinkedList<Quantiles> getStreamSummary() {
        int i;
        int level;
        LinkedList<Quantiles> summary = new LinkedList<Quantiles>();
        if (!this.quantiles.get(this.maxLevel).isEmpty()) {
            summary.add(this.quantiles.get(this.maxLevel).getNewestElement());
            return summary;
        }
        Quantiles bigBlock = this.quantiles.get(this.maxLevel - 1).getNewestElement();
        int leftBorder = this.quantiles.get(this.maxLevel - 1).getLifeTime(0);
        int rightBorder = this.quantiles.get(this.maxLevel - 1).getLifeTime(0) + this.quantiles.get(this.maxLevel - 1).getSize(0);
        int maxUncovered = this.quantiles.get(0).getSize(0);
        for (level = this.maxLevel - 2; level >= 0 && leftBorder > maxUncovered; --level) {
            for (i = this.quantiles.get(level).getAll().size() - 1; i > -1; --i) {
                if (leftBorder <= this.quantiles.get(level).getLifeTime(i)) continue;
                leftBorder = this.quantiles.get(level).getLifeTime(i);
                summary.addFirst(this.quantiles.get(level).get(i));
            }
        }
        summary.add(bigBlock);
        for (level = this.maxLevel - 2; level >= 0 && rightBorder < this.windowSize - maxUncovered; --level) {
            for (i = 0; i < this.quantiles.get(level).getAll().size(); ++i) {
                if (rightBorder >= this.quantiles.get(level).getLifeTime(i) + this.quantiles.get(level).getSize(i)) continue;
                rightBorder = this.quantiles.get(level).getLifeTime(i) + this.quantiles.get(level).getSize(i);
                summary.addLast(this.quantiles.get(level).get(i));
            }
        }
        return summary;
    }

    private LinkedList<Double> getFinalSummary() {
        LinkedList<Quantiles> summary = this.getStreamSummary();
        LinkedList<Double> finalSummary = new LinkedList<Double>();
        for (Quantiles aSummary : summary) {
            Float weight = this.computeLevelForEpsilon(aSummary.getEpsilon());
            for (int j = 0; j < aSummary.getQuantiles().size(); ++j) {
                int k = 0;
                while ((float)k <= weight.floatValue()) {
                    finalSummary.addAll(aSummary.getQuantiles());
                    ++k;
                }
            }
        }
        Collections.sort(finalSummary);
        return finalSummary;
    }

    private Float computeLevelForEpsilon(Float epsilon) {
        Double argument = (double)(2.0f * epsilon.floatValue() * (float)(2 * this.maxLevel + 2)) / this.epsilon;
        Double level = (double)this.maxLevel - Math.log(argument) / Math.log(2.0);
        return Float.valueOf(level.floatValue());
    }

    private void slideWindow() {
        for (int i = 0; i < this.maxLevel + 1; ++i) {
            this.quantiles.get(i).slideWindowByOnePosition();
        }
    }

    public String toString() {
        return this.getClass().getCanonicalName() + " { epsilon=" + this.epsilon + " }";
    }

    public static Builder quantiles(double ... quantiles) {
        return new Builder().quantiles(quantiles);
    }

    public static class Builder {
        private Collection<Double> monitored = new ArrayList<Double>();
        private double error = 0.05;

        public Builder quantiles(double ... quantiles) {
            for (double quantile : quantiles) {
                this.monitored.add(quantile);
            }
            return this;
        }

        public Builder error(double epsilon) {
            this.error = epsilon;
            return this;
        }

        public WindowSketchQuantiles create() {
            return new WindowSketchQuantiles(this.monitored, this.error);
        }
    }

    public class Quantiles
    implements Serializable {
        private static final long serialVersionUID = -6060440214958903531L;
        private Float epsilon;
        private LinkedList<Double> quantiles = new LinkedList();

        public Quantiles(Float epsilon, LinkedList<Double> quantiles) {
            this.epsilon = epsilon;
            this.quantiles = quantiles;
        }

        public Double getQuantile(float phi) {
            int position = Math.round(phi * (float)this.quantiles.size());
            return this.quantiles.get(position);
        }

        public LinkedList<Double> getQuantiles() {
            return this.quantiles;
        }

        Float getEpsilon() {
            return this.epsilon;
        }
    }

    public class Block
    implements Serializable {
        private static final long serialVersionUID = 7802824333706107860L;
        private Float epsilon;
        private Integer blockSize;
        private LinkedList<Double> summaryOfLastBlock;
        private GKQuantiles quantileEstimator;

        Block(Float epsilon, Integer blockSize) {
            this.epsilon = epsilon;
            this.blockSize = blockSize;
            this.quantileEstimator = new GKQuantiles(WindowSketchQuantiles.this.monitored, epsilon.floatValue());
            this.summaryOfLastBlock = new LinkedList();
        }

        void insert(Double item) {
            this.quantileEstimator.observe(item);
            if (Objects.equals(this.quantileEstimator.getCount(), this.blockSize)) {
                this.createSummary();
                this.quantileEstimator = new GKQuantiles(WindowSketchQuantiles.this.monitored, this.epsilon.floatValue());
            }
        }

        Integer getBlockSize() {
            return this.blockSize;
        }

        LinkedList<Double> getSummary() {
            return this.summaryOfLastBlock;
        }

        Float getEpsilon() {
            return this.epsilon;
        }

        private void createSummary() {
            Float phi = this.epsilon;
            LinkedList<Double> summary = new LinkedList<Double>();
            while (phi.floatValue() <= 1.0f) {
                summary.add(this.quantileEstimator.get(phi.floatValue()));
                phi = Float.valueOf(phi.floatValue() + this.epsilon.floatValue());
            }
            this.summaryOfLastBlock = summary;
        }
    }
}

