/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.web;

import java.io.IOException;
import java.util.Arrays;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.metrics.instrument.Tag;
import org.springframework.metrics.instrument.TagFormatter;
import org.springframework.metrics.instrument.web.RestTemplateUrlTemplateHolder;

public class RestTemplateTagConfigurer {
    private final TagFormatter tagFormatter;

    public RestTemplateTagConfigurer(TagFormatter tagFormatter) {
        this.tagFormatter = tagFormatter;
    }

    Iterable<Tag> clientHttpRequestTags(HttpRequest request, ClientHttpResponse response) {
        String status;
        String urlTemplate = RestTemplateUrlTemplateHolder.getRestTemplateUrlTemplate();
        if (urlTemplate == null) {
            urlTemplate = "none";
        }
        try {
            status = response == null ? "CLIENT_ERROR" : Integer.valueOf(response.getRawStatusCode()).toString();
        }
        catch (IOException e) {
            status = "IO_ERROR";
        }
        String host = request.getURI().getHost();
        if (host == null) {
            host = "none";
        }
        String strippedUrlTemplate = urlTemplate.replaceAll("^https?://[^/]+/", "");
        return Arrays.asList(Tag.of("method", request.getMethod().name()), Tag.of("uri", this.tagFormatter.formatTagValue(strippedUrlTemplate)), Tag.of("status", status), Tag.of("clientName", host));
    }
}

