/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.web;

import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.metrics.instrument.Tag;
import org.springframework.metrics.instrument.TagFormatter;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerMapping;

public class WebmvcTagConfigurer {
    private final TagFormatter tagFormatter;

    public WebmvcTagConfigurer(TagFormatter tagFormatter) {
        this.tagFormatter = tagFormatter;
    }

    public Iterable<Tag> httpLongRequestTags(HttpServletRequest request, Object handler) {
        return Arrays.asList(this.method(request), this.uri(request));
    }

    public Iterable<Tag> httpRequestTags(HttpServletRequest request, HttpServletResponse response) {
        return Arrays.asList(this.method(request), this.uri(request), this.exception(request), this.status(response));
    }

    public Tag method(HttpServletRequest request) {
        return Tag.of("method", request.getMethod());
    }

    public Tag status(HttpServletResponse response) {
        return Tag.of("status", Integer.valueOf(response.getStatus()).toString());
    }

    public Tag uri(HttpServletRequest request) {
        String uri = (String)request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
        if (uri == null) {
            uri = request.getPathInfo();
        }
        if (!StringUtils.hasText((String)uri)) {
            uri = "/";
        }
        return Tag.of("uri", (uri = this.tagFormatter.formatTagValue(uri.substring(1))).isEmpty() ? "root" : uri);
    }

    public Tag exception(HttpServletRequest request) {
        Object exception = request.getAttribute("exception");
        if (exception != null) {
            return Tag.of("exception", exception.getClass().getSimpleName());
        }
        return Tag.of("exception", "None");
    }
}

