/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mobile.device;

import javax.servlet.http.HttpServletRequest;
import org.springframework.mobile.device.Device;
import org.springframework.web.context.request.RequestAttributes;

public class DeviceUtils {
    public static final String CURRENT_DEVICE_ATTRIBUTE = "currentDevice";

    public static Device getCurrentDevice(HttpServletRequest request) {
        return (Device)request.getAttribute(CURRENT_DEVICE_ATTRIBUTE);
    }

    public static Device getRequiredCurrentDevice(HttpServletRequest request) {
        Device device = DeviceUtils.getCurrentDevice(request);
        if (device == null) {
            throw new IllegalStateException("No currenet device is set in this request and one is required - have you configured a DeviceResolvingHandlerInterceptor?");
        }
        return device;
    }

    public static Device getCurrentDevice(RequestAttributes attributes) {
        return (Device)attributes.getAttribute(CURRENT_DEVICE_ATTRIBUTE, 0);
    }
}

