/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mobile.device.site;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.mobile.device.site.SitePreference;
import org.springframework.mobile.device.site.SitePreferenceRepository;
import org.springframework.web.util.CookieGenerator;
import org.springframework.web.util.WebUtils;

public class CookieSitePreferenceRepository
extends CookieGenerator
implements SitePreferenceRepository {
    private static final String DEFAULT_COOKIE_NAME = CookieSitePreferenceRepository.class.getName() + ".SITE_PREFERENCE";

    public CookieSitePreferenceRepository() {
        this.setCookieName(DEFAULT_COOKIE_NAME);
    }

    public CookieSitePreferenceRepository(String cookieDomain) {
        this.setCookieName(DEFAULT_COOKIE_NAME);
        this.setCookieDomain(cookieDomain);
    }

    public void saveSitePreference(SitePreference preference, HttpServletRequest request, HttpServletResponse response) {
        this.addCookie(response, preference.name());
    }

    public SitePreference loadSitePreference(HttpServletRequest request) {
        Cookie cookie = WebUtils.getCookie((HttpServletRequest)request, (String)this.getCookieName());
        return cookie != null ? SitePreference.valueOf(cookie.getValue()) : null;
    }
}

