/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.actuator;

import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.modulith.core.ApplicationModules;
import org.springframework.modulith.core.util.ApplicationModulesExporter;
import org.springframework.util.Assert;
import org.springframework.util.function.SingletonSupplier;

@Endpoint(id="modulith")
public class ApplicationModulesEndpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationModulesEndpoint.class);
    private final SingletonSupplier<String> structure;

    private ApplicationModulesEndpoint(Supplier<String> precomputed) {
        LOGGER.debug("Activating Spring Modulith actuator.");
        this.structure = SingletonSupplier.of(precomputed);
    }

    public static ApplicationModulesEndpoint precomputed(Supplier<String> precomputed) {
        Assert.notNull(precomputed, (String)"Precomputed content must not be null!");
        return new ApplicationModulesEndpoint(precomputed);
    }

    public static ApplicationModulesEndpoint ofApplicationModules(Supplier<ApplicationModules> modules) {
        Assert.notNull(modules, (String)"ApplicationModules must not be null!");
        return new ApplicationModulesEndpoint(() -> new ApplicationModulesExporter((ApplicationModules)modules.get()).toJson());
    }

    @ReadOperation
    String getApplicationModules() {
        return (String)this.structure.obtain();
    }
}

