/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.aptk.tools.matcher.impl;

import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.springframework.modulith.aptk.tools.ElementUtils;
import org.springframework.modulith.aptk.tools.matcher.CriteriaMatcher;

public class ByQualifiedNameMatcher
implements CriteriaMatcher<Element, String> {
    @Override
    public boolean checkForMatchingCharacteristic(Element element, String toCheckFor) {
        if (element == null || toCheckFor == null) {
            return false;
        }
        switch (element.getKind()) {
            case ENUM: 
            case INTERFACE: 
            case ANNOTATION_TYPE: 
            case CLASS: {
                TypeElement typeElement = ElementUtils.CastElement.castToTypeElement(element);
                return typeElement != null && toCheckFor != null && typeElement.getQualifiedName().toString().equals(toCheckFor);
            }
            case PACKAGE: {
                PackageElement packageElement = (PackageElement)element;
                return packageElement != null && toCheckFor != null && packageElement.getQualifiedName().toString().equals(toCheckFor);
            }
        }
        return element != null && toCheckFor != null && element.getSimpleName().toString().equals(toCheckFor);
    }

    @Override
    public String getStringRepresentationOfPassedCharacteristic(String toGetStringRepresentationFor) {
        return toGetStringRepresentationFor;
    }
}

