/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.aptk.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class Utilities {
    private Utilities() {
    }

    public static <T> Set<T> convertArrayToSet(T[] array) {
        if (array == null) {
            return null;
        }
        HashSet<T> set = new HashSet<T>(array.length);
        for (T element : array) {
            if (element == null) continue;
            set.add(element);
        }
        return set;
    }

    @SafeVarargs
    public static <T> Set<T> convertVarargsToSet(T ... varargs) {
        return varargs != null ? new HashSet<T>(Arrays.asList(varargs)) : new HashSet();
    }

    @SafeVarargs
    public static <T> List<T> convertVarargsToList(T ... varargs) {
        return varargs != null ? Arrays.asList(varargs) : new ArrayList();
    }

    @SafeVarargs
    public static <T> T[] convertVarargsToArray(T ... varargs) {
        Object[] e = new Object[]{};
        if (varargs == null) {
            return e;
        }
        return varargs;
    }
}

