/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.events.jackson;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.modulith.events.config.EventSerializationConfigurationExtension;
import org.springframework.modulith.events.jackson.JacksonEventSerializer;
import org.springframework.util.Assert;

@Configuration(proxyBeanMethods=false)
class JacksonEventSerializationConfiguration
implements EventSerializationConfigurationExtension {
    private final ObjectProvider<ObjectMapper> mapper;
    private final ApplicationContext context;

    public JacksonEventSerializationConfiguration(ObjectProvider<ObjectMapper> mapper, ApplicationContext context) {
        Assert.notNull(mapper, (String)"ObjectMapper must not be null!");
        Assert.notNull((Object)context, (String)"ApplicationContext must not be null!");
        this.mapper = mapper;
        this.context = context;
    }

    @Bean
    public JacksonEventSerializer jacksonEventSerializer() {
        return new JacksonEventSerializer(() -> (ObjectMapper)this.mapper.getIfAvailable(() -> this.defaultObjectMapper()));
    }

    private ObjectMapper defaultObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        mapper.registerModules(this.context.getBeansOfType(Module.class).values());
        return mapper;
    }
}

