/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.events.jdbc;

import java.sql.Connection;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.modulith.events.jdbc.DatabaseSchemaLocator;
import org.springframework.modulith.events.jdbc.DatabaseType;
import org.springframework.modulith.events.jdbc.JdbcConfigurationProperties;
import org.springframework.util.Assert;

class DatabaseSchemaInitializer
implements InitializingBean {
    private final DataSource dataSource;
    private final ResourceLoader resourceLoader;
    private final DatabaseType databaseType;
    private final JdbcOperations jdbcOperations;
    private final JdbcConfigurationProperties properties;

    DatabaseSchemaInitializer(DataSource dataSource, ResourceLoader resourceLoader, DatabaseType databaseType, JdbcOperations jdbcOperations, JdbcConfigurationProperties properties) {
        Assert.isTrue((boolean)properties.getSchemaInitialization().isEnabled(), (String)"Schema initialization disabled! Initializer should not have been registered!");
        this.dataSource = dataSource;
        this.resourceLoader = resourceLoader;
        this.databaseType = databaseType;
        this.jdbcOperations = jdbcOperations;
        this.properties = properties;
        properties.verify(databaseType);
    }

    public void afterPropertiesSet() throws Exception {
        try (Connection connection = this.dataSource.getConnection();){
            boolean useSchema;
            String initialSchema = connection.getSchema();
            String schemaName = this.properties.getSchema();
            boolean bl = useSchema = schemaName != null && !schemaName.isEmpty();
            if (useSchema) {
                if (this.eventPublicationTableExists(schemaName)) {
                    return;
                }
                this.jdbcOperations.execute("CREATE SCHEMA IF NOT EXISTS " + schemaName);
                this.jdbcOperations.execute(this.databaseType.getSetSchemaSql(schemaName));
            }
            DatabaseSchemaLocator locator = new DatabaseSchemaLocator(this.resourceLoader);
            new ResourceDatabasePopulator(new Resource[]{locator.getSchemaResource(this.databaseType)}).execute(this.dataSource);
            if (initialSchema != null && useSchema) {
                this.jdbcOperations.execute(this.databaseType.getSetSchemaSql(initialSchema));
            }
        }
    }

    private boolean eventPublicationTableExists(String schema) {
        String query = "SELECT COUNT(*)\nFROM information_schema.tables\nWHERE table_schema = ? AND table_name = 'EVENT_PUBLICATION'\n";
        Integer count = (Integer)this.jdbcOperations.queryForObject(query, Integer.class, new Object[]{schema});
        return count != null && count > 0;
    }
}

