/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.events.jdbc;

import java.util.Arrays;
import java.util.UUID;
import org.springframework.util.Assert;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum DatabaseType {
    HSQLDB("hsqldb", "HSQL Database Engine"),
    H2("h2", "H2"),
    MYSQL("mysql", "MySQL"){

        @Override
        Object uuidToDatabase(UUID id) {
            return id.toString();
        }

        @Override
        UUID databaseToUUID(Object id) {
            return UUID.fromString(id.toString());
        }

        @Override
        boolean isSchemaSupported() {
            return false;
        }
    }
    ,
    POSTGRES("postgresql", "PostgreSQL"),
    MSSQL("sqlserver", "Microsoft SQL Server"){

        @Override
        Object uuidToDatabase(UUID id) {
            return id.toString();
        }

        @Override
        UUID databaseToUUID(Object id) {
            return UUID.fromString(id.toString());
        }

        @Override
        boolean isSchemaSupported() {
            return false;
        }
    };

    static final String SCHEMA_NOT_SUPPORTED = "Setting the schema name not supported on MySQL!";
    private final String value;
    private final String fullName;

    static DatabaseType from(String productName) {
        return Arrays.stream(DatabaseType.values()).filter(it -> it.fullName.equalsIgnoreCase(productName)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unsupported database type: " + productName));
    }

    private DatabaseType(String value, String fullName) {
        this.value = value;
        this.fullName = fullName;
    }

    Object uuidToDatabase(UUID id) {
        return id;
    }

    UUID databaseToUUID(Object id) {
        Assert.isInstanceOf(UUID.class, (Object)id, (String)"Database value not of type UUID!");
        return (UUID)id;
    }

    String getSchemaResourceFilename() {
        return "/schema-" + this.value + ".sql";
    }

    boolean isSchemaSupported() {
        return true;
    }

    String getSetSchemaSql(String schema) {
        if (!this.isSchemaSupported()) {
            throw new IllegalArgumentException(SCHEMA_NOT_SUPPORTED);
        }
        return switch (this) {
            case H2, HSQLDB -> "SET SCHEMA " + schema;
            case POSTGRES -> "SET search_path TO " + schema;
            default -> throw new IllegalArgumentException(SCHEMA_NOT_SUPPORTED);
        };
    }
}

