/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.events.jdbc;

import org.springframework.lang.Nullable;
import org.springframework.modulith.events.jdbc.DatabaseType;
import org.springframework.modulith.events.support.CompletionMode;
import org.springframework.util.Assert;

public class JdbcRepositorySettings {
    private final DatabaseType databaseType;
    private final String schema;
    private final CompletionMode completionMode;

    JdbcRepositorySettings(DatabaseType databaseType, CompletionMode completionMode, @Nullable String schema) {
        Assert.notNull((Object)((Object)databaseType), (String)"Database type must not be null!");
        Assert.notNull((Object)completionMode, (String)"Completion mode must not be null!");
        this.databaseType = databaseType;
        this.schema = schema;
        this.completionMode = completionMode;
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    @Nullable
    public String getSchema() {
        return this.schema;
    }

    public boolean isDeleteCompletion() {
        return this.completionMode == CompletionMode.DELETE;
    }
}

