/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.events.kafka;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.kafka.KafkaAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.PropertySource;
import org.springframework.kafka.support.converter.ByteArrayJsonMessageConverter;
import org.springframework.kafka.support.converter.RecordMessageConverter;

@AutoConfiguration
@AutoConfigureBefore(value={KafkaAutoConfiguration.class})
@ConditionalOnClass(value={ObjectMapper.class})
@ConditionalOnProperty(name={"spring.modulith.events.kafka.enable-json"}, havingValue="true", matchIfMissing=true)
@PropertySource(value={"classpath:kafka-json.properties"})
class KafkaJacksonConfiguration {
    KafkaJacksonConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean(value={RecordMessageConverter.class})
    ByteArrayJsonMessageConverter jsonMessageConverter(ObjectProvider<ObjectMapper> mapper) {
        return new ByteArrayJsonMessageConverter((ObjectMapper)mapper.getIfUnique(() -> new ObjectMapper()));
    }
}

