/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.junit;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.springframework.lang.Nullable;
import org.springframework.modulith.junit.Changes;
import org.springframework.modulith.junit.StateStore;
import org.springframework.modulith.junit.TestExecutionCondition;

public class ModulithExecutionCondition
implements ExecutionCondition {
    private static final Collection<String> IDE_PACKAGES = Set.of("org.eclipse.jdt", "com.intellij");
    @Nullable
    private static final TestExecutionCondition CONDITION;

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        if (CONDITION == null) {
            return ConditionEvaluationResult.enabled((String)"Optimization disabled in IDE execution!");
        }
        if (context.getTestMethod().isPresent()) {
            return ConditionEvaluationResult.enabled((String)"Not filtering on a per method basis!");
        }
        return context.getTestClass().map(testClass -> {
            StateStore store = new StateStore(context);
            Changes changes = store.getChanges();
            return changes.isEmpty() ? ConditionEvaluationResult.enabled((String)"No changes detected!") : CONDITION.evaluate(new TestExecutionCondition.ConditionContext((Class<?>)testClass, changes));
        }).orElseGet(() -> ConditionEvaluationResult.enabled((String)"Not a test class context!"));
    }

    private static boolean hasIdeRoot(Stream<StackWalker.StackFrame> frames) {
        List<StackWalker.StackFrame> all = frames.toList();
        String rootClassName = all.get(all.size() - 1).getClassName();
        return IDE_PACKAGES.stream().anyMatch(rootClassName::startsWith);
    }

    static {
        StackWalker walker = StackWalker.getInstance();
        CONDITION = walker.walk(ModulithExecutionCondition::hasIdeRoot) != false ? null : new TestExecutionCondition();
    }
}

