/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.junit;

import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.config.ConfigDataEnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.modulith.junit.Changes;
import org.springframework.modulith.junit.ModulithExecutionCondition;
import org.springframework.modulith.junit.diff.FileModificationDetector;
import org.springframework.util.Assert;

class StateStore {
    private static final Logger log = LoggerFactory.getLogger(StateStore.class);
    private final ExtensionContext.Store store;

    StateStore(ExtensionContext context) {
        Assert.notNull((Object)context, (String)"ExtensionContext must not be null!");
        this.store = context.getRoot().getStore(ExtensionContext.Namespace.create((Object[])new Object[]{ModulithExecutionCondition.class}));
    }

    Changes getChanges() {
        return (Changes)this.store.getOrComputeIfAbsent((Object)"changed-files", s -> {
            StandardEnvironment environment = new StandardEnvironment();
            ConfigDataEnvironmentPostProcessor.applyTo((ConfigurableEnvironment)environment);
            if (Boolean.TRUE == environment.getProperty("spring.modulith.test.skip-optimizations", Boolean.class)) {
                return Changes.NONE;
            }
            FileModificationDetector detector = FileModificationDetector.getDetector((PropertyResolver)environment);
            Changes result = Changes.of(detector.getModifiedFiles());
            if (log.isInfoEnabled()) {
                log.trace("Detected changes:");
                log.trace("-----------------");
                result.forEach(it -> log.info(it.toString()));
            }
            return Changes.of(detector.getModifiedFiles());
        });
    }
}

