/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.junit.diff;

import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.PropertyResolver;
import org.springframework.lang.Nullable;
import org.springframework.modulith.junit.diff.FileModificationDetector;
import org.springframework.modulith.junit.diff.JGitUtil;
import org.springframework.modulith.junit.diff.ModifiedFile;
import org.springframework.util.StringUtils;

class ReferenceCommitDetector
implements FileModificationDetector {
    private static final Logger log = LoggerFactory.getLogger(ReferenceCommitDetector.class);
    private static final String REFERENCE_COMMIT_PROPERTY = "spring.modulith.test.reference-commit";
    private final String referenceCommit;

    ReferenceCommitDetector(@Nullable String referenceCommit) {
        if (StringUtils.hasText((String)referenceCommit)) {
            log.info("Comparing to git commit {}", (Object)referenceCommit);
            this.referenceCommit = referenceCommit;
        } else {
            log.warn("No reference-commit configured, comparing to HEAD.");
            this.referenceCommit = "HEAD";
        }
    }

    @Override
    public Stream<ModifiedFile> getModifiedFiles() {
        return (Stream)JGitUtil.withRepository(repo -> {
            String localBranch = repo.getFullBranch();
            return JGitUtil.toModifiedFiles(repo, this.referenceCommit, localBranch);
        });
    }

    @Nullable
    public static String getReferenceCommitProperty(PropertyResolver propertyResolver) {
        return propertyResolver.getProperty(REFERENCE_COMMIT_PROPERTY);
    }
}

