/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.junit.diff;

import java.io.File;
import java.util.stream.Stream;
import org.springframework.modulith.junit.diff.FileModificationDetector;
import org.springframework.modulith.junit.diff.JGitUtil;
import org.springframework.modulith.junit.diff.ModifiedFile;
import org.springframework.util.Assert;

class WorkingDirectoryChangesDetector
implements FileModificationDetector {
    private final FileModificationDetector delegate;
    private final String workingDirectory;

    WorkingDirectoryChangesDetector(FileModificationDetector delegate, String workingDirectory) {
        Assert.notNull((Object)delegate, (String)"FileModificationDetector must not be null!");
        Assert.notNull((Object)workingDirectory, (String)"Working folder must not be null!");
        this.delegate = delegate;
        this.workingDirectory = workingDirectory;
    }

    public static WorkingDirectoryChangesDetector of(FileModificationDetector delegate) {
        String currentWorkingDirectory;
        String pathToRepo = (String)JGitUtil.withRepository(it -> it.getDirectory().getParent());
        String repositoryRelative = !pathToRepo.equals(currentWorkingDirectory = new File("").getAbsolutePath()) ? currentWorkingDirectory.substring(pathToRepo.length() + 1) : "";
        return new WorkingDirectoryChangesDetector(delegate, repositoryRelative);
    }

    @Override
    public Stream<ModifiedFile> getModifiedFiles() {
        return this.delegate.getModifiedFiles().filter(it -> it.path().startsWith(this.workingDirectory)).map(it -> it.asRelativeTo(this.workingDirectory));
    }
}

